package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.ZadluzeniePozycja;
import pl.topteam.dps.model.main.ZadluzeniePozycjaCriteria;

public abstract interface ZadluzeniePozycjaMapper {
    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=ZadluzeniePozycjaSqlProvider.class, method="countByExample")
    int countByExample(ZadluzeniePozycjaCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @DeleteProvider(type=ZadluzeniePozycjaSqlProvider.class, method="deleteByExample")
    int deleteByExample(ZadluzeniePozycjaCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Delete({
        "delete from ZADLUZENIE_POZYCJA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Insert({
        "insert into ZADLUZENIE_POZYCJA (INSTYTUCJA_ID, OSOBA_ID, ",
        "ZADLUZENIE_ID, AKTUALNOSC, ",
        "KWOTA, RODZAJ, STATUS, ",
        "DATA_AKTUALIZACJI)",
        "values (#{instytucjaId,jdbcType=BIGINT}, #{osobaId,jdbcType=BIGINT}, ",
        "#{zadluzenieId,jdbcType=BIGINT}, #{aktualnosc,jdbcType=VARCHAR}, ",
        "#{kwota,jdbcType=DECIMAL}, #{rodzaj,jdbcType=VARCHAR}, #{status,jdbcType=VARCHAR}, ",
        "#{dataAktualizacji,jdbcType=DATE})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(ZadluzeniePozycja record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    int mergeInto(ZadluzeniePozycja record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @InsertProvider(type=ZadluzeniePozycjaSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(ZadluzeniePozycja record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=ZadluzeniePozycjaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="INSTYTUCJA_ID", property="instytucjaId", jdbcType=JdbcType.BIGINT),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="ZADLUZENIE_ID", property="zadluzenieId", jdbcType=JdbcType.BIGINT),
        @Result(column="AKTUALNOSC", property="aktualnosc", jdbcType=JdbcType.VARCHAR),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.DECIMAL),
        @Result(column="RODZAJ", property="rodzaj", jdbcType=JdbcType.VARCHAR),
        @Result(column="STATUS", property="status", jdbcType=JdbcType.VARCHAR),
        @Result(column="DATA_AKTUALIZACJI", property="dataAktualizacji", jdbcType=JdbcType.DATE)
    })
    List<ZadluzeniePozycja> selectByExampleWithRowbounds(ZadluzeniePozycjaCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=ZadluzeniePozycjaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="INSTYTUCJA_ID", property="instytucjaId", jdbcType=JdbcType.BIGINT),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="ZADLUZENIE_ID", property="zadluzenieId", jdbcType=JdbcType.BIGINT),
        @Result(column="AKTUALNOSC", property="aktualnosc", jdbcType=JdbcType.VARCHAR),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.DECIMAL),
        @Result(column="RODZAJ", property="rodzaj", jdbcType=JdbcType.VARCHAR),
        @Result(column="STATUS", property="status", jdbcType=JdbcType.VARCHAR),
        @Result(column="DATA_AKTUALIZACJI", property="dataAktualizacji", jdbcType=JdbcType.DATE)
    })
    List<ZadluzeniePozycja> selectByExample(ZadluzeniePozycjaCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Select({
        "select",
        "ID, INSTYTUCJA_ID, OSOBA_ID, ZADLUZENIE_ID, AKTUALNOSC, KWOTA, RODZAJ, STATUS, ",
        "DATA_AKTUALIZACJI",
        "from ZADLUZENIE_POZYCJA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="INSTYTUCJA_ID", property="instytucjaId", jdbcType=JdbcType.BIGINT),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="ZADLUZENIE_ID", property="zadluzenieId", jdbcType=JdbcType.BIGINT),
        @Result(column="AKTUALNOSC", property="aktualnosc", jdbcType=JdbcType.VARCHAR),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.DECIMAL),
        @Result(column="RODZAJ", property="rodzaj", jdbcType=JdbcType.VARCHAR),
        @Result(column="STATUS", property="status", jdbcType=JdbcType.VARCHAR),
        @Result(column="DATA_AKTUALIZACJI", property="dataAktualizacji", jdbcType=JdbcType.DATE)
    })
    ZadluzeniePozycja selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=ZadluzeniePozycjaSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") ZadluzeniePozycja record, @Param("example") ZadluzeniePozycjaCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=ZadluzeniePozycjaSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") ZadluzeniePozycja record, @Param("example") ZadluzeniePozycjaCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=ZadluzeniePozycjaSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(ZadluzeniePozycja record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Update({
        "update ZADLUZENIE_POZYCJA",
        "set INSTYTUCJA_ID = #{instytucjaId,jdbcType=BIGINT},",
          "OSOBA_ID = #{osobaId,jdbcType=BIGINT},",
          "ZADLUZENIE_ID = #{zadluzenieId,jdbcType=BIGINT},",
          "AKTUALNOSC = #{aktualnosc,jdbcType=VARCHAR},",
          "KWOTA = #{kwota,jdbcType=DECIMAL},",
          "RODZAJ = #{rodzaj,jdbcType=VARCHAR},",
          "STATUS = #{status,jdbcType=VARCHAR},",
          "DATA_AKTUALIZACJI = #{dataAktualizacji,jdbcType=DATE}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(ZadluzeniePozycja record);
}