package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.ZleceniePrzedmiot;
import pl.topteam.dps.model.main_gen.ZleceniePrzedmiotCriteria.Criteria;
import pl.topteam.dps.model.main_gen.ZleceniePrzedmiotCriteria.Criterion;
import pl.topteam.dps.model.main.ZleceniePrzedmiotCriteria;

public class ZleceniePrzedmiotSqlProvider {

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String countByExample(ZleceniePrzedmiotCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("ZLECENIE_PRZEDMIOT");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String deleteByExample(ZleceniePrzedmiotCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("ZLECENIE_PRZEDMIOT");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String insertSelective(ZleceniePrzedmiot record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("ZLECENIE_PRZEDMIOT");
        
        if (record.getZlecenieId() != null) {
            sql.VALUES("ZLECENIE_ID", "#{zlecenieId,jdbcType=BIGINT}");
        }
        
        if (record.getInfoDobor() != null) {
            sql.VALUES("INFO_DOBOR", "#{infoDobor,jdbcType=VARCHAR}");
        }
        
        if (record.getKod() != null) {
            sql.VALUES("KOD", "#{kod,jdbcType=VARCHAR}");
        }
        
        if (record.getLiczbaSztuk() != null) {
            sql.VALUES("LICZBA_SZTUK", "#{liczbaSztuk,jdbcType=INTEGER}");
        }
        
        if (record.getNazwa() != null) {
            sql.VALUES("NAZWA", "#{nazwa,jdbcType=VARCHAR}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String selectByExample(ZleceniePrzedmiotCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ZLECENIE_ID");
        } else {
            sql.SELECT("ZLECENIE_ID");
        }
        sql.SELECT("INFO_DOBOR");
        sql.SELECT("KOD");
        sql.SELECT("LICZBA_SZTUK");
        sql.SELECT("NAZWA");
        sql.FROM("ZLECENIE_PRZEDMIOT");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        ZleceniePrzedmiot record = (ZleceniePrzedmiot) parameter.get("record");
        ZleceniePrzedmiotCriteria example = (ZleceniePrzedmiotCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("ZLECENIE_PRZEDMIOT");
        
        if (record.getZlecenieId() != null) {
            sql.SET("ZLECENIE_ID = #{record.zlecenieId,jdbcType=BIGINT}");
        }
        
        if (record.getInfoDobor() != null) {
            sql.SET("INFO_DOBOR = #{record.infoDobor,jdbcType=VARCHAR}");
        }
        
        if (record.getKod() != null) {
            sql.SET("KOD = #{record.kod,jdbcType=VARCHAR}");
        }
        
        if (record.getLiczbaSztuk() != null) {
            sql.SET("LICZBA_SZTUK = #{record.liczbaSztuk,jdbcType=INTEGER}");
        }
        
        if (record.getNazwa() != null) {
            sql.SET("NAZWA = #{record.nazwa,jdbcType=VARCHAR}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("ZLECENIE_PRZEDMIOT");
        
        sql.SET("ZLECENIE_ID = #{record.zlecenieId,jdbcType=BIGINT}");
        sql.SET("INFO_DOBOR = #{record.infoDobor,jdbcType=VARCHAR}");
        sql.SET("KOD = #{record.kod,jdbcType=VARCHAR}");
        sql.SET("LICZBA_SZTUK = #{record.liczbaSztuk,jdbcType=INTEGER}");
        sql.SET("NAZWA = #{record.nazwa,jdbcType=VARCHAR}");
        
        ZleceniePrzedmiotCriteria example = (ZleceniePrzedmiotCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByPrimaryKeySelective(ZleceniePrzedmiot record) {
        SQL sql = new SQL();
        sql.UPDATE("ZLECENIE_PRZEDMIOT");
        
        if (record.getInfoDobor() != null) {
            sql.SET("INFO_DOBOR = #{infoDobor,jdbcType=VARCHAR}");
        }
        
        if (record.getKod() != null) {
            sql.SET("KOD = #{kod,jdbcType=VARCHAR}");
        }
        
        if (record.getLiczbaSztuk() != null) {
            sql.SET("LICZBA_SZTUK = #{liczbaSztuk,jdbcType=INTEGER}");
        }
        
        if (record.getNazwa() != null) {
            sql.SET("NAZWA = #{nazwa,jdbcType=VARCHAR}");
        }
        
        sql.WHERE("ZLECENIE_ID = #{zlecenieId,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    protected void applyWhere(SQL sql, ZleceniePrzedmiotCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}