package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.ZlecenieWyrobMedyczny;
import pl.topteam.dps.model.main_gen.ZlecenieWyrobMedycznyCriteria.Criteria;
import pl.topteam.dps.model.main_gen.ZlecenieWyrobMedycznyCriteria.Criterion;
import pl.topteam.dps.model.main.ZlecenieWyrobMedycznyCriteria;

public class ZlecenieWyrobMedycznySqlProvider {

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String countByExample(ZlecenieWyrobMedycznyCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("ZLECENIE_WYROB_MEDYCZNY");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String deleteByExample(ZlecenieWyrobMedycznyCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("ZLECENIE_WYROB_MEDYCZNY");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String insertSelective(ZlecenieWyrobMedyczny record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("ZLECENIE_WYROB_MEDYCZNY");
        
        if (record.getAdresOsobyId() != null) {
            sql.VALUES("ADRES_OSOBY_ID", "#{adresOsobyId,jdbcType=BIGINT}");
        }
        
        if (record.getOsobaId() != null) {
            sql.VALUES("OSOBA_ID", "#{osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getZlecenieNadrzedneId() != null) {
            sql.VALUES("ZLECENIE_NADRZEDNE_ID", "#{zlecenieNadrzedneId,jdbcType=BIGINT}");
        }
        
        if (record.getDataWystawienia() != null) {
            sql.VALUES("DATA_WYSTAWIENIA", "#{dataWystawienia,jdbcType=DATE}");
        }
        
        if (record.getDysfunkcja() != null) {
            sql.VALUES("DYSFUNKCJA", "#{dysfunkcja,jdbcType=VARCHAR}");
        }
        
        if (record.getIcd10() != null) {
            sql.VALUES("ICD10", "#{icd10,jdbcType=VARCHAR}");
        }
        
        if (record.getNazwaDokumentu() != null) {
            sql.VALUES("NAZWA_DOKUMENTU", "#{nazwaDokumentu,jdbcType=VARCHAR}");
        }
        
        if (record.getNrDokumentu() != null) {
            sql.VALUES("NR_DOKUMENTU", "#{nrDokumentu,jdbcType=VARCHAR}");
        }
        
        if (record.getNrEwidencyjny() != null) {
            sql.VALUES("NR_EWIDENCYJNY", "#{nrEwidencyjny,jdbcType=VARCHAR}");
        }
        
        if (record.getRodzaj() != null) {
            sql.VALUES("RODZAJ", "#{rodzaj,jdbcType=VARCHAR}");
        }
        
        if (record.getZaopatrzeniePoSp() != null) {
            sql.VALUES("ZAOPATRZENIE_PO_SP", "#{zaopatrzeniePoSp,jdbcType=VARCHAR}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String selectByExample(ZlecenieWyrobMedycznyCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("ADRES_OSOBY_ID");
        sql.SELECT("OSOBA_ID");
        sql.SELECT("ZLECENIE_NADRZEDNE_ID");
        sql.SELECT("DATA_WYSTAWIENIA");
        sql.SELECT("DYSFUNKCJA");
        sql.SELECT("ICD10");
        sql.SELECT("NAZWA_DOKUMENTU");
        sql.SELECT("NR_DOKUMENTU");
        sql.SELECT("NR_EWIDENCYJNY");
        sql.SELECT("RODZAJ");
        sql.SELECT("ZAOPATRZENIE_PO_SP");
        sql.FROM("ZLECENIE_WYROB_MEDYCZNY");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        ZlecenieWyrobMedyczny record = (ZlecenieWyrobMedyczny) parameter.get("record");
        ZlecenieWyrobMedycznyCriteria example = (ZlecenieWyrobMedycznyCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("ZLECENIE_WYROB_MEDYCZNY");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getAdresOsobyId() != null) {
            sql.SET("ADRES_OSOBY_ID = #{record.adresOsobyId,jdbcType=BIGINT}");
        }
        
        if (record.getOsobaId() != null) {
            sql.SET("OSOBA_ID = #{record.osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getZlecenieNadrzedneId() != null) {
            sql.SET("ZLECENIE_NADRZEDNE_ID = #{record.zlecenieNadrzedneId,jdbcType=BIGINT}");
        }
        
        if (record.getDataWystawienia() != null) {
            sql.SET("DATA_WYSTAWIENIA = #{record.dataWystawienia,jdbcType=DATE}");
        }
        
        if (record.getDysfunkcja() != null) {
            sql.SET("DYSFUNKCJA = #{record.dysfunkcja,jdbcType=VARCHAR}");
        }
        
        if (record.getIcd10() != null) {
            sql.SET("ICD10 = #{record.icd10,jdbcType=VARCHAR}");
        }
        
        if (record.getNazwaDokumentu() != null) {
            sql.SET("NAZWA_DOKUMENTU = #{record.nazwaDokumentu,jdbcType=VARCHAR}");
        }
        
        if (record.getNrDokumentu() != null) {
            sql.SET("NR_DOKUMENTU = #{record.nrDokumentu,jdbcType=VARCHAR}");
        }
        
        if (record.getNrEwidencyjny() != null) {
            sql.SET("NR_EWIDENCYJNY = #{record.nrEwidencyjny,jdbcType=VARCHAR}");
        }
        
        if (record.getRodzaj() != null) {
            sql.SET("RODZAJ = #{record.rodzaj,jdbcType=VARCHAR}");
        }
        
        if (record.getZaopatrzeniePoSp() != null) {
            sql.SET("ZAOPATRZENIE_PO_SP = #{record.zaopatrzeniePoSp,jdbcType=VARCHAR}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("ZLECENIE_WYROB_MEDYCZNY");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("ADRES_OSOBY_ID = #{record.adresOsobyId,jdbcType=BIGINT}");
        sql.SET("OSOBA_ID = #{record.osobaId,jdbcType=BIGINT}");
        sql.SET("ZLECENIE_NADRZEDNE_ID = #{record.zlecenieNadrzedneId,jdbcType=BIGINT}");
        sql.SET("DATA_WYSTAWIENIA = #{record.dataWystawienia,jdbcType=DATE}");
        sql.SET("DYSFUNKCJA = #{record.dysfunkcja,jdbcType=VARCHAR}");
        sql.SET("ICD10 = #{record.icd10,jdbcType=VARCHAR}");
        sql.SET("NAZWA_DOKUMENTU = #{record.nazwaDokumentu,jdbcType=VARCHAR}");
        sql.SET("NR_DOKUMENTU = #{record.nrDokumentu,jdbcType=VARCHAR}");
        sql.SET("NR_EWIDENCYJNY = #{record.nrEwidencyjny,jdbcType=VARCHAR}");
        sql.SET("RODZAJ = #{record.rodzaj,jdbcType=VARCHAR}");
        sql.SET("ZAOPATRZENIE_PO_SP = #{record.zaopatrzeniePoSp,jdbcType=VARCHAR}");
        
        ZlecenieWyrobMedycznyCriteria example = (ZlecenieWyrobMedycznyCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByPrimaryKeySelective(ZlecenieWyrobMedyczny record) {
        SQL sql = new SQL();
        sql.UPDATE("ZLECENIE_WYROB_MEDYCZNY");
        
        if (record.getAdresOsobyId() != null) {
            sql.SET("ADRES_OSOBY_ID = #{adresOsobyId,jdbcType=BIGINT}");
        }
        
        if (record.getOsobaId() != null) {
            sql.SET("OSOBA_ID = #{osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getZlecenieNadrzedneId() != null) {
            sql.SET("ZLECENIE_NADRZEDNE_ID = #{zlecenieNadrzedneId,jdbcType=BIGINT}");
        }
        
        if (record.getDataWystawienia() != null) {
            sql.SET("DATA_WYSTAWIENIA = #{dataWystawienia,jdbcType=DATE}");
        }
        
        if (record.getDysfunkcja() != null) {
            sql.SET("DYSFUNKCJA = #{dysfunkcja,jdbcType=VARCHAR}");
        }
        
        if (record.getIcd10() != null) {
            sql.SET("ICD10 = #{icd10,jdbcType=VARCHAR}");
        }
        
        if (record.getNazwaDokumentu() != null) {
            sql.SET("NAZWA_DOKUMENTU = #{nazwaDokumentu,jdbcType=VARCHAR}");
        }
        
        if (record.getNrDokumentu() != null) {
            sql.SET("NR_DOKUMENTU = #{nrDokumentu,jdbcType=VARCHAR}");
        }
        
        if (record.getNrEwidencyjny() != null) {
            sql.SET("NR_EWIDENCYJNY = #{nrEwidencyjny,jdbcType=VARCHAR}");
        }
        
        if (record.getRodzaj() != null) {
            sql.SET("RODZAJ = #{rodzaj,jdbcType=VARCHAR}");
        }
        
        if (record.getZaopatrzeniePoSp() != null) {
            sql.SET("ZAOPATRZENIE_PO_SP = #{zaopatrzeniePoSp,jdbcType=VARCHAR}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    protected void applyWhere(SQL sql, ZlecenieWyrobMedycznyCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}