package pl.topteam.dps.enums;

import java.nio.charset.Charset;

import pl.topteam.dps.enums.interfaces.EnumOpis;

import com.google.common.base.Charsets;

public enum CharsetEncoding implements EnumOpis {
	ISO_8859_2(Charset.forName("ISO-8859-2"), "ISO-8859-2"),
	UTF_8(Charsets.UTF_8, Charsets.UTF_8.name())
	;
	
	private Charset charset;
	private String opis;
	
	private CharsetEncoding(Charset charset, String opis) {
		this.charset = charset;
		this.opis = opis;
	}
	
	public Charset getCharset() {
		return charset;
	}
	
	@Override
	public String getOpis() {
		return opis;
	}
}
