package pl.topteam.dps.enums;

import org.apache.commons.lang3.StringUtils;

public enum Plec {
	M("M", "mężczyzna", "mężczyźni"),
	K("K", "kobieta", "kobiety");

	private String skrot;
	private String nazwa;
	private String dopLmn;

	private Plec(String skrot, String nazwa, String dopLmn) {
		this.skrot = skrot;
		this.nazwa = nazwa;
		this.dopLmn = dopLmn;
	}

	public String getSkrot() {
		return this.skrot;
	}

	public String getNazwa() {
		return this.nazwa;
	}

	public String getDopLmn() {
		return this.dopLmn;
	}

	public static Plec getBySkrot(String skrot) {
		if(StringUtils.isNotEmpty(skrot)) {
			for(Plec plec : Plec.values()) {
				if(StringUtils.equalsIgnoreCase(skrot, plec.getSkrot())) {
					return plec;
				}
			}
		}

		return null;
	}
}
