package pl.topteam.dps.enums;

import pl.topteam.dps.enums.interfaces.EnumOpis;

public enum RodzajInformacji implements EnumOpis {
// FAKTURY VAT ZA LEKI
	FAKTURY_LEKI(
			GrupaInformacji.FAKTURY_LEKI,
			TypPolaInformacjiDodatkowej.LICZBA_I,
			null, "FAKTURY VAT - leki"),
	
// LEKI ZLECENIA STAŁE
	LEKI_STALE(
			GrupaInformacji.LEKI_ZLECENIA,
			TypPolaInformacjiDodatkowej.PORA_DNIA_LICZBA_I_MULTI,
			null, "LEKI - zlecenia stałe"),
	
// LEKI PODANIA DORAŹNE
	LEKI_DORAZNE(
			GrupaInformacji.LEKI_DORAZNE,
			TypPolaInformacjiDodatkowej.LICZBA_I,
			null, "LEKI - podania doraźne"),
	
// MONITOROWANIE MIESZKAŃCÓW
	MONITOROWANIE_SCHORZENIA(
			GrupaInformacji.MONITOROWANIE,
			TypPolaInformacjiDodatkowej.SLOWNIK_LICZBA_I_MULTI,
			NazwySlownikow.KOD_OBIEKTU_MONITOROWANIA, "MONITOROWANIE - ze wzgl. schorzenia"),
	
// ODWIEDZINY MIESZKAŃCÓW
	ODWIEDZINY_MIESZKANCOW(
			GrupaInformacji.ODWIEDZINY,
			TypPolaInformacjiDodatkowej.LICZBA_I,
			null, "ODWIEDZINY MIESZKAŃCÓW - liczba"),
	
// POMIARY
	POBRANIE_MATERIALU_BADANIA(
			GrupaInformacji.POBRANIE_MATERIALU,
			TypPolaInformacjiDodatkowej.SLOWNIK_LICZBA_I_MULTI,
			NazwySlownikow.KOD_RODZAJU_MATERIALU_BADANIA, "POBRANIE MATERIALU DO BADAŃ"),
	POMIAR_ALKOMATEM(
			GrupaInformacji.POMIAR,
			TypPolaInformacjiDodatkowej.LICZBA_I,
			null, "POMIAR ALKOMATEM"),
	POMIAR_GLIKEMII(
			GrupaInformacji.POMIAR,
			TypPolaInformacjiDodatkowej.LICZBA_I,
			null, "POMIAR GLIKEMII"),
	POMIAR_RR(
			GrupaInformacji.POMIAR,
			TypPolaInformacjiDodatkowej.LICZBA_I,
			null, "POMIAR RR"),
			
// PRACOWNIK - wykonał
	PRACOWNIK_WYKONAL(
			GrupaInformacji.PRACOWNIK_WYKONAL,
			TypPolaInformacjiDodatkowej.PRACOWNIK,
			null, "PRACOWNIK WYKONAŁ"),
	
// REJESTRY
	REJESTR_LAMPA_UV(
			GrupaInformacji.R_LAMPA_UV,
			TypPolaInformacjiDodatkowej.LICZBA_I,
			null, "REJESTR UV - czas pracy (min)"),
	
// STAN LICZBY MIESZKAŃCÓW
	STAN_MIESZKANCOW_HOSPITALIZACJA(
			GrupaInformacji.STAN_MIESZKANCOW,
			TypPolaInformacjiDodatkowej.LICZBA_I,
			null, "STAN MIESZKAŃCÓW - hospitalizowani"),
	STAN_MIESZKANCOW(
			GrupaInformacji.STAN_MIESZKANCOW,
			TypPolaInformacjiDodatkowej.LICZBA_I,
			null, "STAN MIESZKAŃCÓW - liczba mieszkańców"),
	STAN_MIESZKANCOW_NOWOPRZYBYLI(
			GrupaInformacji.STAN_MIESZKANCOW,
			TypPolaInformacjiDodatkowej.LICZBA_I,
			null, "STAN MIESZKAŃCÓW - nowoprzybyli"),
	STAN_MIESZKANCOW_URLOPY(
			GrupaInformacji.STAN_MIESZKANCOW,
			TypPolaInformacjiDodatkowej.LICZBA_I,
			null, "STAN MIESZKAŃCÓW - urlopy"),
	STAN_MIESZKANCOW_ZGONY(
			GrupaInformacji.STAN_MIESZKANCOW,
			TypPolaInformacjiDodatkowej.LICZBA_I,
			null, "STAN MIESZKAŃCÓW - zgony")
	;
	
	public enum GrupaInformacji {
		FAKTURY_LEKI,
		LEKI_ZLECENIA,
		LEKI_DORAZNE,
		MONITOROWANIE,
		ODWIEDZINY,
		POBRANIE_MATERIALU,
		POMIAR,
		PRACOWNIK_WYKONAL,
		R_LAMPA_UV,
		STAN_MIESZKANCOW
	}
	
	private GrupaInformacji grupaInformacji;
	private NazwySlownikow nazwaSlownika;
	private TypPolaInformacjiDodatkowej typPola;
	private String opis;
	
	private RodzajInformacji(
			GrupaInformacji grupaInformacji,
			TypPolaInformacjiDodatkowej typPola,
			NazwySlownikow nazwaSlownika, String opis) {
		this.grupaInformacji = grupaInformacji;
		this.nazwaSlownika = nazwaSlownika;
		this.typPola = typPola;
		this.opis = opis;
	}
	
	public NazwySlownikow getNazwaSlownika() {
		return this.nazwaSlownika;
	}
	
	public TypPolaInformacjiDodatkowej getTypPola() {
		return this.typPola;
	}

	public GrupaInformacji getGrupaInformacji() {
		return grupaInformacji;
	}

	@Override
	public String getOpis() {
		return this.opis;
	}
}
