package pl.topteam.dps.enums;

import java.util.EnumSet;
import java.util.Set;

import pl.topteam.dps.enums.interfaces.EnumOpis;
import pl.topteam.dps.enums.sm.EnumStateMachine;

public enum StatusNieobecnosci implements EnumOpis, EnumStateMachine<StatusNieobecnosci> {
	/**
	 * Jeżeli rozpoczęto realizację procesu rozliczania odpisów dni,
	 * nie można wprowadzać zwrotów za tę nieobecność
	 */
	DO_ROZLICZENIA("do rozliczenia w odpłatnościach"),
	/**
	 * Na jej podstawie nie można dokonywać odliczeń
	 */
	BRAK_ODLICZENIA("nie przeznaczona do odliczeń"),
	/**
	 * Gdy wszystkie dni przeznaczone do zwrotu zostały rozliczone z tej nieobecności
	 * (albo pracownik DPS uznał, że rozliczona), nie można wprowadzać odpisów za tę nieobecność
	 */
	ROZLICZONA("rozliczona")
	;

	private String opis;

	private StatusNieobecnosci(String opis) {
		this.opis = opis;
	}

	@Override
	public String getOpis() {
		return this.opis;
	}

	@Override
	public Set<StatusNieobecnosci> getTransitions() {
		// w tym przypadku można dowolnie zmieniać stany informacji
		return EnumSet.allOf(StatusNieobecnosci.class);
	}
}
