package pl.topteam.dps.enums;

import java.util.EnumSet;
import java.util.Set;

import pl.topteam.dps.enums.interfaces.EnumOpis;
import pl.topteam.dps.enums.sm.EnumStateMachine;

public enum StatusPozycjiZadluzenia implements EnumOpis, EnumStateMachine<StatusPozycjiZadluzenia> {
	W_REALIZACJI("w realizacji") {
		@Override
		public Set<StatusPozycjiZadluzenia> getTransitions() {
			return EnumSet.of(W_REALIZACJI, NIESCIAGALNA, SPLACONA, WYGASZONA_SMIERC);
		}
	},
	NIESCIAGALNA("nieściągalna") {
		@Override
		public Set<StatusPozycjiZadluzenia> getTransitions() {
			return EnumSet.of(NIESCIAGALNA, WYGASZONA_SMIERC);
		}
	},
	SPLACONA("spłacona w całości") {
		@Override
		public Set<StatusPozycjiZadluzenia> getTransitions() {
			return EnumSet.of(SPLACONA, WYGASZONA_SMIERC);
		}
	},
	WYGASZONA_SMIERC("wygaszona z powodu śmierci osoby") {
		@Override
		public Set<StatusPozycjiZadluzenia> getTransitions() {
			return EnumSet.of(WYGASZONA_SMIERC);
		}
	}
	;
	
	private String opis;
	
	private StatusPozycjiZadluzenia(String opis) {
		this.opis = opis;
	}
	
	@Override
	public String getOpis() {
		return this.opis;
	}
}
