package pl.topteam.dps.enums;

import pl.topteam.dps.enums.interfaces.EnumOpis;

public enum TypPolaInformacjiDodatkowej implements EnumOpis {
	DATA("data", "data"),
	/** Data 'od kiedy' ma wyświetlać przypomnienie (chyba, że użytkownik pominie wszytkie przeszłe) */
	DATA_PRZYPOMNIENIA("data przypomnienia", "data przyp."),
	
	LICZBA_I("pole całkowitoliczbowe", "l. całk."),
	
	LICZBA_D("pole liczbowe (liczba z podwójną precyzją)", "l. zmien."),
	
	PORA_DNIA("pora dnia podawania leków", "pora dnia"),
	PORA_DNIA_LICZBA_I("pora dnia podawania leków (l. całk.)", "pora dnia (l. całk.)"),
	PORA_DNIA_LICZBA_I_MULTI("pora dnia podawania leków (l. całk.)(wielokrotny wybór)", "pora dnia (l. całk.)(wielokrotny wybór)"),
	
	PRACOWNIK("pracownik DPS", "pracownik"),
	PRACOWNIK_LICZBA_I("pracownik DPS (l. całk.)", "pracownik (l. całk.)"),
	PRACOWNIK_LICZBA_I_MULTI("pracownik DPS (l. całk.)(wielokrotny wybór)", "pracownik (l. całk.)(wielokrotny wybór)"),
	
	SLOWNIK("pole słownikowe", "wart. słowa"),
	SLOWNIK_LICZBA_I("pole słownikowe (l. całk.)", "pole słownikowe (l. całk.)"),
	SLOWNIK_LICZBA_I_MULTI("pole słownikowe (l. całk.)(wielokrotny wybór)", "pole słownikowe (l. całk.)(wielokrotny wybór)"),
	SLOWNIK_MULTI("pole słownikowe (wielkrotnego wyboru)", "wart. słowa (wielokrotny wybór)"),
	
	TEKST_KROTKI("pole tekstowe (krótkie, 1 linia, 100 znaków)", "t. krótki"),
	
	TEKST_DLUGI("pole tekstowe (długie)", "t. długi"),
	
	WARTOSC_LOGICZNA("tak/nie", "tak/nie")
	;

	private String opis;
	private String skrot;
	
	private TypPolaInformacjiDodatkowej(String opis, String skrot) {
		this.opis = opis;
		this.skrot = skrot;
	}

	@Override
	public String getOpis() {
		return this.opis;
	}
	
	public String getSkrot() {
		return this.skrot;
	}
}
