package pl.topteam.dps.model.main;

import java.util.EnumSet;

import net.karneim.pojobuilder.GeneratePojoBuilder;
import pl.topteam.dps.enums.TypEwidencji;
import pl.topteam.utils.wydruki.zmienne.model.ListaZmiennychWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydruku;

@GeneratePojoBuilder
@ListaZmiennychWydruku(
	id = "ewidencjaDps",
	zmienne = {
		@ZmiennaWydruku(nazwa = "dataOd", opis = "data początku ważności wpisu ewidencyjnego"),
		@ZmiennaWydruku(nazwa = "dataDo", opis = "data końca ważności wpisu ewidencyjnego"),
		@ZmiennaWydruku(nazwa = "dokadOdszedlId", opis = "[tylko dla wyprowadzek] unikalny identyfikator miejsca wyprowadzki mieszkańca"),
		@ZmiennaWydruku(nazwa = "id", opis = "unikalny identyfikator wpisu ewidencyjnego"),
		@ZmiennaWydruku(nazwa = "nrAktuZgonu", opis = "[tylko dla wpisu zgonu] numer aktu zgonu mieszkańca"),
		@ZmiennaWydruku(nazwa = "numerEwidencyjny", opis = "[tylko dla mieszkańca] numer ewidencyjny mieszkańca"),
		@ZmiennaWydruku(nazwa = "osobaId", opis = "unikalny identyfikator osoby w programie, której dotyczy wpis"),
		@ZmiennaWydruku(nazwa = "typ", opis = "typ wpisu ewidencyjnego"),
		@ZmiennaWydruku(nazwa = "profilDomu", opis = "profil domu")
	}
)
public class EwidencjaDps extends pl.topteam.dps.model.main_gen.EwidencjaDps {
	private static final long serialVersionUID = -6159746781670225425L;

	/**
	 * W przypadku gdy wpis jest zgonem osoby, to numer aktu zgonu
	 * wpisywany jest w pole jako numer ewidencji.
	 */
	public String getNrAktuZgonu() {
		TypEwidencji typ = super.getTyp();
		if(typ != null
				&& (EnumSet.of(TypEwidencji.MIESZKANIEC_ZGON, TypEwidencji.OSOBA_OCZEKUJACA_ZGON).contains(typ))) {
			return super.getNumerEwidencyjny();
		}
		return null;
	}
}