/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.io.IOException;
import java.util.Properties;
import org.h2.server.web.TTDPSWebServlet;
import org.h2.server.web.WebServer;
import org.h2.server.web.WebSession;

public class TTDPSWebServer
extends WebServer {
    private static String CONSOLE_DEFAULT_LANGUAGE = "pl";
    private TTDPSWebServlet parent;

    public TTDPSWebServer(TTDPSWebServlet parent) {
        this.parent = parent;
    }

    public void init(String ... args) {
        super.init(args);
    }

    WebSession createNewSession(String hostAddr) {
        WebSession session = super.createNewSession(hostAddr);
        session.put("language", (Object)CONSOLE_DEFAULT_LANGUAGE);
        this.readTranslations(session, CONSOLE_DEFAULT_LANGUAGE);
        return session;
    }

    Properties getDefaultRequestAttributes() {
        return new Properties();
    }

    byte[] getFile(String file) throws IOException {
        this.trace("getFile <" + file + ">");
        byte[] data = this.parent.getResource("jsp/h2Console/" + file);
        if (data == null) {
            this.trace(" null");
        } else {
            this.trace(" size=" + data.length);
        }
        return data;
    }

    public TTDPSWebServlet getParent() {
        return this.parent;
    }
}

