/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.h2.server.web.PageParser;
import org.h2.server.web.TTDPSWebServer;
import org.h2.server.web.TTWebApp;
import org.h2.server.web.WebSession;
import org.h2.util.IOUtils;
import org.h2.util.New;
import org.h2.util.StringUtils;

public class TTDPSWebServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final byte[] EMPTY_BYTES = new byte[0];
    private static final HashMap<String, byte[]> RESOURCES = New.hashMap();
    private transient TTDPSWebServer server;

    public void init() {
        ServletConfig config = this.getServletConfig();
        Enumeration en = config.getInitParameterNames();
        ArrayList list = New.arrayList();
        while (en.hasMoreElements()) {
            String name = en.nextElement().toString();
            String value = config.getInitParameter(name);
            if (!name.startsWith("-")) {
                name = "-" + name;
            }
            list.add(name);
            if (value.length() <= 0) continue;
            list.add(value);
        }
        String[] args = new String[list.size()];
        list.toArray(args);
        this.server = new TTDPSWebServer(this);
        this.server.init(args);
    }

    public void destroy() {
        this.server.stop();
    }

    private boolean allow(HttpServletRequest req) {
        if (this.server.getAllowOthers()) {
            return true;
        }
        String addr = req.getRemoteAddr();
        try {
            InetAddress address = InetAddress.getByName(addr);
            return address.isLoopbackAddress();
        }
        catch (UnknownHostException e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    private String getAllowedFile(HttpServletRequest req, String requestedFile) {
        if (!this.allow(req)) {
            return "notAllowed.jsp";
        }
        if (requestedFile.length() == 0) {
            return "index.do";
        }
        return requestedFile;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String value;
        String name;
        req.setCharacterEncoding("UTF-8");
        String file = req.getPathInfo();
        if (file == null) {
            resp.sendRedirect(req.getRequestURI() + "/");
            return;
        }
        if (file.startsWith("/")) {
            file = file.substring(1);
        }
        file = this.getAllowedFile(req, file);
        byte[] bytes = null;
        Properties attributes = this.server.getDefaultRequestAttributes();
        Enumeration en = req.getAttributeNames();
        while (en.hasMoreElements()) {
            name = en.nextElement().toString();
            value = req.getAttribute(name).toString();
            attributes.put(name, value);
        }
        en = req.getParameterNames();
        while (en.hasMoreElements()) {
            name = en.nextElement().toString();
            value = req.getParameter(name);
            attributes.put(name, value);
        }
        WebSession session = null;
        String sessionId = attributes.getProperty("jsessionid");
        if (sessionId != null) {
            session = this.server.getSession(sessionId);
        }
        TTWebApp app = new TTWebApp(this.server);
        app.setSession(session, attributes);
        String ifModifiedSince = req.getHeader("if-modified-since");
        String hostAddr = req.getRemoteAddr();
        file = app.processRequest(file, hostAddr);
        session = app.getSession();
        String mimeType = app.getMimeType();
        boolean cache = app.getCache();
        if (cache && this.server.getStartDateTime().equals(ifModifiedSince)) {
            resp.setStatus(304);
            return;
        }
        bytes = this.server.getFile(file);
        if (bytes == null) {
            resp.sendError(404);
            bytes = StringUtils.utf8Encode((String)("File not found: " + file));
        } else {
            if (session != null && file.endsWith(".jsp")) {
                String page = StringUtils.utf8Decode((byte[])bytes);
                page = PageParser.parse((String)page, (Map)session.map);
                bytes = StringUtils.utf8Encode((String)page);
            }
            resp.setContentType(mimeType);
            if (!cache) {
                resp.setHeader("Cache-Control", "no-cache");
            } else {
                resp.setHeader("Cache-Control", "max-age=10");
                resp.setHeader("Last-Modified", this.server.getStartDateTime());
            }
        }
        if (bytes != null) {
            ServletOutputStream out = resp.getOutputStream();
            out.write(bytes);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doGet(req, resp);
    }

    public byte[] getResource(String name) throws IOException {
        byte[] data = null;
        if (!RESOURCES.containsKey(name)) {
            FileInputStream in = new FileInputStream(this.getServletContext().getRealPath("/") + name);
            data = IOUtils.readBytesAndClose((InputStream)in, (int)0);
            RESOURCES.put(name, data);
        } else {
            data = RESOURCES.get(name);
        }
        return data == null ? EMPTY_BYTES : data;
    }
}

