/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.h2.trigger.zadluzenie;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.tools.TriggerAdapter;

public class AfterZadluzeniePozycjaUpdate
extends TriggerAdapter {
    private static String SELECT_POZYCJA_WG_AKTUALNOSCI = "SELECT COUNT(*) AS rowcount FROM ZADLUZENIE_POZYCJA zp WHERE zp.ZADLUZENIE_ID = ? AND zp.AKTUALNOSC = 'DIRTY'";
    private static String UPDATE_STATUS_ZADLUZENIA = "UPDATE ZADLUZENIE z SET z.AKTUALNOSC = ? WHERE z.ID = ?";
    private static String UPDATE_AKTUALNOSC_CALOSC_OSOBA = "UPDATE ZADLUZENIE_POZYCJA zp SET zp.AKTUALNOSC = 'DIRTY' WHERE zp.ZADLUZENIE_ID = ? AND zp.RODZAJ='CALOSC' AND zp.OSOBA_ID = ?";
    private static String UPDATE_AKTUALNOSC_CALOSC_INSTYTUCJA = "UPDATE ZADLUZENIE_POZYCJA zp SET zp.AKTUALNOSC = 'DIRTY' WHERE zp.ZADLUZENIE_ID = ? AND zp.RODZAJ='CALOSC' AND zp.INSTYTUCJA_ID = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(Connection con, ResultSet oldRow, ResultSet newRow) throws SQLException {
        Long idZadluzenia = oldRow.getLong("ZADLUZENIE_ID");
        PreparedStatement psSelectZadluzenie = null;
        PreparedStatement psUpdateZadluzenie = null;
        try {
            psSelectZadluzenie = con.prepareStatement(SELECT_POZYCJA_WG_AKTUALNOSCI);
            psUpdateZadluzenie = con.prepareStatement(UPDATE_STATUS_ZADLUZENIA);
            psSelectZadluzenie.setLong(1, idZadluzenia);
            ResultSet rs = psSelectZadluzenie.executeQuery();
            rs.next();
            psUpdateZadluzenie.setLong(2, idZadluzenia);
            if (rs.getInt("rowcount") < 1) {
                psUpdateZadluzenie.setString(1, "ACTUAL");
            } else {
                psUpdateZadluzenie.setString(1, "DIRTY");
            }
            rs.close();
            if (psUpdateZadluzenie.executeUpdate() == 0) {
                throw new SQLException("Nie zmieniono statusu dla ZADLUZENIA o id: " + idZadluzenia);
            }
        }
        finally {
            SQLException sqlEx = null;
            try {
                if (psSelectZadluzenie != null) {
                    psSelectZadluzenie.close();
                }
            }
            catch (SQLException e) {
                sqlEx = e;
            }
            if (psUpdateZadluzenie != null) {
                psUpdateZadluzenie.close();
            }
            if (sqlEx != null) {
                throw sqlEx;
            }
        }
        if (!oldRow.getString("RODZAJ").equalsIgnoreCase("CALOSC")) {
            try (Statement psUpdate = null;){
                if (oldRow.getLong("OSOBA_ID") != 0L) {
                    psUpdate = con.prepareStatement(UPDATE_AKTUALNOSC_CALOSC_OSOBA);
                    psUpdate.setLong(2, oldRow.getLong("OSOBA_ID"));
                } else {
                    psUpdate = con.prepareStatement(UPDATE_AKTUALNOSC_CALOSC_INSTYTUCJA);
                    psUpdate.setLong(2, oldRow.getLong("INSTYTUCJA_ID"));
                }
                psUpdate.setLong(1, idZadluzenia);
                psUpdate.executeUpdate();
            }
        }
    }
}

