/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.enums;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import pl.topteam.dps.enums.RodzajSlownika;
import pl.topteam.dps.enums.TypSlownika;
import pl.topteam.dps.enums.interfaces.EnumOpis;

public enum NazwySlownikow implements EnumOpis
{
    KOD_CHARAKTERU_WIZYTY_LEKARZA("Charakter wizyty lekarza", "kodCharakteruWizytyLekarzaSlownik"),
    KOD_DODATKU_POBIERANEGO_SWIADCZENIA("Dodatek dla pobieranego \u015bwiadczenia", "kodDodatkuPobieranegoSwiadczeniaSlownik"),
    KOD_LEKARZA("Lekarz", "kodLekarzaSlownik"),
    KOD_MIEJSCA_PRZYJSCIA_DO_DPS("Miejsce przyj\u015bcia do DPS", "kodMiejscaPrzyjsciaDoDPSSlownik"),
    KOD_MIEJSCA_ODEJSCIA_Z_DPS("Miejsce odej\u015bcia z DPSu", "kodMiejscaOdejsciaZDPSuSlownik"),
    KOD_MIEJSCA_ZGONU("Miejsce zgonu osoby", "kodMiejscaZgonuSlownik"),
    KOD_NIEDOMAGANIA_MIESZKANCA("Niedomagania pacjenta (kwalifikacja piel\u0119gniarska)", "kodNiedomaganiaPacjentaSlownik"),
    KOD_OBIEKTU_MONITOROWANIA("Przedmiot monitorowania mieszka\u0144ca", "kodObiektuMonitorowaniaSlownik"),
    KOD_OBYWATELSTWA("Obywatelstwo", "kodObywatelstwaSlownik"){

        @Override
        public RodzajSlownika getRodzajSlownika() {
            return RodzajSlownika.NIEEDYTOWALNY;
        }
    }
    ,
    KOD_ORGANU_DAROWIZNA_LEKOW("Organ przekazuj\u0105cy leki w darze", "kodOrganuDarowiznaLekowSlownik"),
    KOD_ORGANU_ODP_POGRZEB("Oragan odpowiedzialny za poch\u00f3wek os\u00f3b", "kodOrganuOdpPogrzeb"),
    KOD_ORGANU_SCIGANIA("Organ \u015bciagnia", "kodOrganuSciganiaSlownik"),
    KOD_ORGANU_WYDAJACEGO_DEC_KIERUJACA("Organ wydaj\u0105cy decyzj\u0119 kieruj\u0105c\u0105", "kodOrgWydajacyDecKierujacaSlownik"),
    KOD_ORGANU_WYDAJACEGO_DEC_ODPLATNOSC("Organ wydaj\u0105cy decyzj\u0119 o alimentacji/odp\u0142atno\u015bci", "kodOrgWydajacyDecOOdplatnosciSlownik"),
    KOD_ORGANU_WYDAJACEGO_DEC_UMIESZCZAJACA("Organ wydaj\u0105cy decyzj\u0119 umieszczaj\u0105c\u0105", "kodOrgWydajacyDecUmieszczajaceSlownik"),
    KOD_ORGANU_WYDAJACEGO_DOWOD_OS("Organ wydaj\u0105cy dow\u00f3d osobisty", "kodOrganuWydDowodOsSlownik"),
    KOD_ORGANU_WYDAJACEGO_ORZ_NIEPEL("Organ wydaj\u0105cy orzeczenie o niepe\u0142nosprawno\u015bci", "kodOrganuWydOrzeczNiepelSlownik"),
    KOD_PODMIOTU_ODBIOR_ODPADOW("Podmiot odbieraj\u0105cy odpady medyczne", "kodPodmiotuOdbiorOdpadowSlownik"),
    KOD_POWODU_WIZYTY_LEKARZA("Pow\u00f3d wizyty lekarza", "kodPowoduWizytyLekarzaSlownik"),
    KOD_PRACOWNIKA_PK("Pracownik PK", "kodPracownikaPKSlownik"),
    KOD_RODZAJU_DIAGNOZY("Rodzaj wystawianej diagnozy", "kodRodzajuWystawianejDiagnozySlownik"),
    KOD_RODZAJU_DYZURU_PIELEGNIARSKIEGO("Rodzaju dy\u017curu piel\u0119gniarskiego", "kodRodzajuDyzuruPielegniarskiegoSlownik"){

        @Override
        public RodzajSlownika getRodzajSlownika() {
            return RodzajSlownika.NIEEDYTOWALNY;
        }
    }
    ,
    KOD_RODZAJU_KWOTY_UMOWA_APTEKA("Rodzaj kwoty na umowie z aptek\u0105", "kodRodzajuKwotyAptekaSlownik"),
    KOD_RODZAJU_MATERIALU_BADANIA("Rodzaj materia\u0142u pobranego do bada\u0144", "kodRodzajuMaterialuBadaniaSlownik"),
    KOD_RODZAJU_NIEOBECNOSCI("Rodzaj nieobecno\u015bci mieszka\u0144ca", "kodRodzajuNieobecnosciSlownik"),
    KOD_RODZAJU_ODPADU_MEDYCZNEGO("Rodzaj odpadu medycznego", "kodRodzajuOdpaduMedycznegoSlownik"),
    KOD_RODZAJU_POSTANOWIENIA_SADU("Rodzaj postanowienia s\u0105du", "kodRodzajuPostanowieniaSaduSlownik"),
    KOD_RODZAJU_ZAPOMOGI("Rodzaj zapomogi", "kodRodzajuZapomogiSlownik"),
    KOD_STANU_CYWILNEGO("Stan cywilny", "kodStanuCywilnegoSlownik"){

        @Override
        public RodzajSlownika getRodzajSlownika() {
            return RodzajSlownika.NIEEDYTOWALNY;
        }
    }
    ,
    KOD_STANU_ZDROWIA("Stan zdrowia", "kodStanuZdrowiaSlownik"),
    KOD_STOPNIA_NIEPELNOSPRAWNOSCI("Stopie\u0144 niepe\u0142nosprawno\u015bci", "kodStopniaNiepelnosprawnosciSlownik"){

        @Override
        public RodzajSlownika getRodzajSlownika() {
            return RodzajSlownika.NIEEDYTOWALNY;
        }
    }
    ,
    KOD_STOPNIA_POKREWIENSTWA("Stopie\u0144 pokrewie\u0144stwa", "kodStopniaPokrewienstwaSlownik"),
    KOD_TYTULU_UPRAWNIENIA("Tytu\u0142 uprawnienia (wyroby medyczne)", "kodTytuluUprawnieniaSlownik"){

        @Override
        public RodzajSlownika getRodzajSlownika() {
            return RodzajSlownika.NIEEDYTOWALNY;
        }
    }
    ,
    KOD_TYTULU_UPRAWNIENIA_DODATKOWEGO("Tytu\u0142 uprawnienia dodatkowego  (wyroby medyczne)", "kodTytuluUprawnieniaDodatkowegoSlownik"){

        @Override
        public RodzajSlownika getRodzajSlownika() {
            return RodzajSlownika.NIEEDYTOWALNY;
        }
    }
    ,
    KOD_USC("USC", "kodUSCSlownik"),
    KOD_WYZNANIA("Wyznanie", "kodWyznaniaSlownik"),
    KOD_WYKSZTALCENIA("Wykszta\u0142cenie", "kodWyksztalceniaSlownik"),
    KOD_ZAKRESU_POSTANOWIENIA_SADU("Zakres postanowienia s\u0105dowego", "kodZakresuPostanowienia");

    private String nazwaServerContext;
    private String opis;

    private NazwySlownikow(String opis, String nazwaServerContext) {
        this.nazwaServerContext = nazwaServerContext;
        this.opis = opis;
    }

    public RodzajSlownika getRodzajSlownika() {
        return RodzajSlownika.EDYTOWALNY;
    }

    public TypSlownika getTypSlownika() {
        return TypSlownika.WART_S;
    }

    public String getNazwaServerContext() {
        return this.nazwaServerContext;
    }

    @Override
    public String getOpis() {
        return this.opis;
    }

    static {
        ArrayList listaNazw = Lists.newArrayList();
        for (NazwySlownikow nazwaSlownika : NazwySlownikow.values()) {
            Preconditions.checkArgument((nazwaSlownika.getRodzajSlownika() != null ? 1 : 0) != 0, (Object)("Rodzaj s\u0142ownika jest wymagany dla " + nazwaSlownika));
            Preconditions.checkArgument((nazwaSlownika.getTypSlownika() != null ? 1 : 0) != 0, (Object)("Typ s\u0142ownika jest wymagany dla " + nazwaSlownika));
            if (!StringUtils.isNotEmpty((CharSequence)nazwaSlownika.getNazwaServerContext())) continue;
            Preconditions.checkArgument((!listaNazw.contains(nazwaSlownika.getNazwaServerContext()) ? 1 : 0) != 0, (Object)("Klucze s\u0142ownik\u00f3w przechowywane w context'cie s\u0105 powielone: " + nazwaSlownika.getNazwaServerContext()));
            listaNazw.add(nazwaSlownika.getNazwaServerContext());
        }
    }
}

