/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.model.main;

import com.google.common.base.Function;
import java.math.BigDecimal;
import java.util.Date;
import javax.annotation.Nonnull;
import net.karneim.pojobuilder.GeneratePojoBuilder;
import org.joda.time.YearMonth;
import pl.topteam.dps.enums.StatusFaktury;
import pl.topteam.dps.model.main.Osoba;
import pl.topteam.dps.model.main.PodmiotP;
import pl.topteam.dps.model.main.PodmiotPBuilder;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydrukuPominPole;

@GeneratePojoBuilder
public class Faktura
extends pl.topteam.dps.model.main_gen.Faktura {
    private static final long serialVersionUID = -6159746781670225425L;
    @ZmiennaWydrukuPominPole
    private String nrWewFormat;
    private Osoba osoba;
    public static Function<Faktura, YearMonth> OKRES_FAKTURY = new Function<Faktura, YearMonth>(){

        public YearMonth apply(@Nonnull Faktura f) {
            return YearMonth.fromDateFields((Date)f.getDataWystawienia());
        }
    };
    public static Function<Faktura, StatusFaktury> STATUS_FAKTURY = new Function<Faktura, StatusFaktury>(){

        public StatusFaktury apply(@Nonnull Faktura f) {
            return f.getStatus();
        }
    };
    public static Function<Faktura, BigDecimal> KWOTA_M_FAKTURY = new Function<Faktura, BigDecimal>(){

        public BigDecimal apply(@Nonnull Faktura f) {
            return f.getKwotaM();
        }
    };
    public static Function<Faktura, PodmiotP> PODMIOT_ZOBOWIAZANY = new Function<Faktura, PodmiotP>(){

        public PodmiotP apply(@Nonnull Faktura f) {
            return new PodmiotPBuilder().withOsobaId(f.getOsobaId()).withOsoba(f.getOsoba()).build();
        }
    };

    public Osoba getOsoba() {
        return this.osoba;
    }

    public void setOsoba(Osoba osoba) {
        this.osoba = osoba;
    }

    public String getNrWewFormat() {
        return this.nrWewFormat;
    }

    public void setNrWewFormat(String nrWewFormat) {
        this.nrWewFormat = nrWewFormat;
    }
}

