/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.model.main;

import com.google.common.base.Function;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import net.karneim.pojobuilder.GeneratePojoBuilder;
import pl.topteam.dps.enums.RodzajPlatnika;
import pl.topteam.dps.model.main.InstytucjaDoplacajaca;
import pl.topteam.dps.model.main.Osoba;
import pl.topteam.dps.model.main.PodmiotP;
import pl.topteam.dps.model.main.PodmiotPBuilder;

@GeneratePojoBuilder
public class NaliczeniePobyt
extends pl.topteam.dps.model.main_gen.NaliczeniePobyt {
    private static final long serialVersionUID = 3780943669755394388L;
    private RodzajPlatnika rodzajPlatnika;
    private Long osobaId;
    private Long instytucjaId;
    private Long osobaLiczonyId;
    private Integer rok;
    private Integer miesiac;
    private Osoba mieszkaniec;
    private Osoba osoba;
    private InstytucjaDoplacajaca instytucja;
    public static Function<NaliczeniePobyt, BigDecimal> KWOTA_NALICZENIA = new Function<NaliczeniePobyt, BigDecimal>(){

        public BigDecimal apply(@Nonnull NaliczeniePobyt np) {
            return np.getKwota();
        }
    };
    public static Function<NaliczeniePobyt, RodzajPlatnika> RODZAJ_PLATNIKA_NALICZENIA = new Function<NaliczeniePobyt, RodzajPlatnika>(){

        public RodzajPlatnika apply(@Nonnull NaliczeniePobyt np) {
            return np.getRodzajPlatnika();
        }
    };
    public static Function<NaliczeniePobyt, Osoba> MIESZKANIEC_NALICZENIA = new Function<NaliczeniePobyt, Osoba>(){

        public Osoba apply(@Nonnull NaliczeniePobyt np) {
            return np.getMieszkaniec();
        }
    };
    public static Function<NaliczeniePobyt, PodmiotP> PODMIOT_ZOBOWIAZANY = new Function<NaliczeniePobyt, PodmiotP>(){

        public PodmiotP apply(@Nonnull NaliczeniePobyt np) {
            return new PodmiotPBuilder().withOsobaId(np.getOsobaId()).withOsoba(np.getOsoba()).withInstytucjaId(np.getInstytucjaId()).withInstytucja(np.getInstytucja()).build();
        }
    };

    public Long getOsobaId() {
        return this.osobaId;
    }

    public void setOsobaId(Long osobaId) {
        this.osobaId = osobaId;
    }

    public Long getInstytucjaId() {
        return this.instytucjaId;
    }

    public void setInstytucjaId(Long instytucjaId) {
        this.instytucjaId = instytucjaId;
    }

    public Long getOsobaLiczonyId() {
        return this.osobaLiczonyId;
    }

    public void setOsobaLiczonyId(Long osobaLiczonyId) {
        this.osobaLiczonyId = osobaLiczonyId;
    }

    public Integer getRok() {
        return this.rok;
    }

    public void setRok(Integer rok) {
        this.rok = rok;
    }

    public Integer getMiesiac() {
        return this.miesiac;
    }

    public void setMiesiac(Integer miesiac) {
        this.miesiac = miesiac;
    }

    public Osoba getMieszkaniec() {
        return this.mieszkaniec;
    }

    public void setMieszkaniec(Osoba mieszkaniec) {
        this.mieszkaniec = mieszkaniec;
    }

    public Osoba getOsoba() {
        return this.osoba;
    }

    public void setOsoba(Osoba osoba) {
        this.osoba = osoba;
    }

    public InstytucjaDoplacajaca getInstytucja() {
        return this.instytucja;
    }

    public void setInstytucja(InstytucjaDoplacajaca instytucja) {
        this.instytucja = instytucja;
    }

    public RodzajPlatnika getRodzajPlatnika() {
        return this.rodzajPlatnika;
    }

    public void setRodzajPlatnika(RodzajPlatnika rodzajPlatnika) {
        this.rodzajPlatnika = rodzajPlatnika;
    }
}

