/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.model.main;

import com.google.common.base.Function;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import net.karneim.pojobuilder.GeneratePojoBuilder;
import org.joda.time.YearMonth;
import pl.topteam.dps.enums.RodzajZadluzenia;
import pl.topteam.dps.model.main.InstytucjaDoplacajaca;
import pl.topteam.dps.model.main.Osoba;
import pl.topteam.dps.model.main.PodmiotP;
import pl.topteam.dps.model.main.PodmiotPBuilder;

@GeneratePojoBuilder
public class OdpisZwrot
extends pl.topteam.dps.model.main_gen.OdpisZwrot {
    private static final long serialVersionUID = -6159746781671225425L;
    private Long mieszkaniecId;
    private Long osobaId;
    private Long instytucjaId;
    private Integer rok;
    private Integer miesiac;
    private RodzajZadluzenia rodzajZadluzenia;
    private BigDecimal kwotaZwrotu;
    private Osoba osoba;
    private InstytucjaDoplacajaca instytucjaDoplacajaca;
    public static Function<OdpisZwrot, YearMonth> OKRES_ODPIS_ZWROT = new Function<OdpisZwrot, YearMonth>(){

        public YearMonth apply(@Nonnull OdpisZwrot oz) {
            return new YearMonth(oz.getRok().intValue(), oz.getMiesiac().intValue());
        }
    };
    public static final Function<OdpisZwrot, RodzajZadluzenia> RODZAJ_ZADLUZENIA_ODPIS_ZWROT = new Function<OdpisZwrot, RodzajZadluzenia>(){

        public RodzajZadluzenia apply(@Nonnull OdpisZwrot oz) {
            return oz.getRodzajZadluzenia();
        }
    };
    public static Function<OdpisZwrot, BigDecimal> KWOTA_ODPISU = new Function<OdpisZwrot, BigDecimal>(){

        public BigDecimal apply(@Nonnull OdpisZwrot oz) {
            return oz.getKwota();
        }
    };
    public static Function<OdpisZwrot, BigDecimal> KWOTA_ZWROTU = new Function<OdpisZwrot, BigDecimal>(){

        public BigDecimal apply(@Nonnull OdpisZwrot oz) {
            return oz.getKwota();
        }
    };
    public static Function<OdpisZwrot, BigDecimal> KWOTA_ZWROTU_Z_ODPISU = new Function<OdpisZwrot, BigDecimal>(){

        public BigDecimal apply(@Nonnull OdpisZwrot oz) {
            return oz.getKwotaZwrotu();
        }
    };
    public static Function<OdpisZwrot, PodmiotP> PODMIOT_ZOBOWIAZANY_ODPIS_ZWROT = new Function<OdpisZwrot, PodmiotP>(){

        public PodmiotP apply(@Nonnull OdpisZwrot oz) {
            return new PodmiotPBuilder().withOsobaId(oz.getOsobaId()).withOsoba(oz.getOsoba()).withInstytucjaId(oz.getInstytucjaId()).withInstytucja(oz.getInstytucjaDoplacajaca()).build();
        }
    };

    public Long getInstytucjaId() {
        return this.instytucjaId;
    }

    public void setInstytucjaId(Long instytucjaId) {
        this.instytucjaId = instytucjaId;
    }

    public Long getMieszkaniecId() {
        return this.mieszkaniecId;
    }

    public void setMieszkaniecId(Long mieszkaniecId) {
        this.mieszkaniecId = mieszkaniecId;
    }

    public Long getOsobaId() {
        return this.osobaId;
    }

    public void setOsobaId(Long osobaId) {
        this.osobaId = osobaId;
    }

    public Integer getRok() {
        return this.rok;
    }

    public void setRok(Integer rok) {
        this.rok = rok;
    }

    public Integer getMiesiac() {
        return this.miesiac;
    }

    public void setMiesiac(Integer miesiac) {
        this.miesiac = miesiac;
    }

    public Osoba getOsoba() {
        return this.osoba;
    }

    public void setOsoba(Osoba osoba) {
        this.osoba = osoba;
    }

    public InstytucjaDoplacajaca getInstytucjaDoplacajaca() {
        return this.instytucjaDoplacajaca;
    }

    public void setInstytucjaDoplacajaca(InstytucjaDoplacajaca instytucjaDoplacajaca) {
        this.instytucjaDoplacajaca = instytucjaDoplacajaca;
    }

    public RodzajZadluzenia getRodzajZadluzenia() {
        return this.rodzajZadluzenia;
    }

    public void setRodzajZadluzenia(RodzajZadluzenia rodzajZadluzenia) {
        this.rodzajZadluzenia = rodzajZadluzenia;
    }

    public BigDecimal getKwotaZwrotu() {
        return this.kwotaZwrotu;
    }

    public void setKwotaZwrotu(BigDecimal kwotaZwrotu) {
        this.kwotaZwrotu = kwotaZwrotu;
    }
}

