/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.model.main;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.karneim.pojobuilder.GeneratePojoBuilder;
import pl.topteam.dps.model.main.GrupaZnakow;
import pl.topteam.security.password.PasswordPreferences;
import pl.topteam.security.password.gen.CharacterGroup;

@GeneratePojoBuilder
public class PolitykaBezpieczenstwa
extends pl.topteam.dps.model.main_gen.PolitykaBezpieczenstwa
implements PasswordPreferences {
    private static final long serialVersionUID = -6159746781670225425L;
    public static final Integer MIN = 5;
    public static final Integer MAX = 20;
    private List<GrupaZnakow> grupyZnakow;

    @Override
    public Integer min() {
        return (Integer)MoreObjects.firstNonNull((Object)this.getMinDlHasla(), (Object)MIN);
    }

    @Override
    public Integer max() {
        return (Integer)MoreObjects.firstNonNull((Object)this.getMaxDlHasla(), (Object)MAX);
    }

    @Override
    public Map<CharacterGroup, Integer> characterGroups() {
        if (this.grupyZnakow == null) {
            return null;
        }
        ImmutableMap.Builder mapaWymagan = ImmutableMap.builder();
        for (GrupaZnakow grupa : this.grupyZnakow) {
            mapaWymagan.put((Object)grupa.getGrupaZnakow(), (Object)grupa.getMinZnakow());
        }
        return mapaWymagan.build();
    }

    @Override
    public String customChars() {
        if (this.grupyZnakow == null) {
            return null;
        }
        return (String)FluentIterable.from(this.grupyZnakow).filter((Predicate)new Predicate<GrupaZnakow>(){

            public boolean apply(@Nonnull GrupaZnakow chg) {
                return CharacterGroup.CUSTOM.equals((Object)chg.getGrupaZnakow());
            }
        }).transform((Function)new Function<GrupaZnakow, String>(){

            public String apply(@Nonnull GrupaZnakow gz) {
                return gz.getZnaki();
            }
        }).first().orNull();
    }

    @Override
    public Boolean getZastosuj() {
        return (Boolean)MoreObjects.firstNonNull((Object)super.getZastosuj(), (Object)false);
    }

    public List<GrupaZnakow> getGrupyZnakow() {
        return this.grupyZnakow != null ? this.grupyZnakow : Lists.newArrayList();
    }

    public void setGrupyZnakow(List<GrupaZnakow> grupyZnakow) {
        this.grupyZnakow = grupyZnakow;
    }
}

