/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.model.main;

import com.google.common.base.Function;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import net.karneim.pojobuilder.GeneratePojoBuilder;
import org.joda.time.YearMonth;
import pl.topteam.dps.enums.RodzajZadluzenia;
import pl.topteam.dps.model.main.InstytucjaDoplacajaca;
import pl.topteam.dps.model.main.OdpisZwrot;
import pl.topteam.dps.model.main.Osoba;
import pl.topteam.dps.model.main.PobieraneSwiadczenie;
import pl.topteam.dps.model.main.PodmiotP;
import pl.topteam.dps.model.main.PodmiotPBuilder;
import pl.topteam.dps.model.main.ZadluzeniePozycja;
import pl.topteam.utils.wydruki.zmienne.model.ListaZmiennychWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydruku;

@ListaZmiennychWydruku(id="swiadczenieZwrot", zmienne={@ZmiennaWydruku(nazwa="instytucja", opis="instytucja do kt\u00f3rej ma nast\u0105pi\u0107/nast\u0105pi\u0142 zwrot \u015bwiadczenia"), @ZmiennaWydruku(nazwa="kwota", opis="kwota zwrotu"), @ZmiennaWydruku(nazwa="mieszkaniec", opis="mieszkaniec, kt\u00f3remu wyp\u0142acano \u015bwiadczenie"), @ZmiennaWydruku(nazwa="swiadczenie", opis="wyp\u0142acane \u015bwiadczenie"), @ZmiennaWydruku(nazwa="zwrotId", opis="czy zwr\u00f3cono/zarejestrowano zwrot")})
@GeneratePojoBuilder
public class SwiadczenieZwrot
extends pl.topteam.dps.model.main_gen.SwiadczenieZwrot {
    private static final long serialVersionUID = 1L;
    private Long mieszkaniecId;
    private Long osobaId;
    private Integer rok;
    private Integer miesiac;
    private RodzajZadluzenia rodzajZadluzenia;
    private Osoba mieszkaniec;
    private InstytucjaDoplacajaca instytucja;
    private ZadluzeniePozycja zadluzeniePozycja;
    private OdpisZwrot zwrot;
    private PobieraneSwiadczenie swiadczenie;
    public static Function<SwiadczenieZwrot, YearMonth> OKRES_ZWROTU = new Function<SwiadczenieZwrot, YearMonth>(){

        public YearMonth apply(@Nonnull SwiadczenieZwrot sz) {
            return new YearMonth(sz.getRok().intValue(), sz.getMiesiac().intValue());
        }
    };
    public static final Function<SwiadczenieZwrot, RodzajZadluzenia> RODZAJ_ZADLUZENIA_ZWROT = new Function<SwiadczenieZwrot, RodzajZadluzenia>(){

        public RodzajZadluzenia apply(@Nonnull SwiadczenieZwrot sz) {
            return sz.getRodzajZadluzenia();
        }
    };
    public static Function<SwiadczenieZwrot, BigDecimal> KWOTA = new Function<SwiadczenieZwrot, BigDecimal>(){

        public BigDecimal apply(@Nonnull SwiadczenieZwrot sz) {
            return sz.getKwota();
        }
    };
    public static Function<SwiadczenieZwrot, PodmiotP> PODMIOT_ZOBOWIAZANY = new Function<SwiadczenieZwrot, PodmiotP>(){

        public PodmiotP apply(@Nonnull SwiadczenieZwrot sz) {
            return new PodmiotPBuilder().withInstytucjaId(sz.getInstytucjaId()).withInstytucja(sz.getInstytucja()).build();
        }
    };

    public Integer getRok() {
        return this.rok;
    }

    public void setRok(Integer rok) {
        this.rok = rok;
    }

    public Integer getMiesiac() {
        return this.miesiac;
    }

    public void setMiesiac(Integer miesiac) {
        this.miesiac = miesiac;
    }

    public InstytucjaDoplacajaca getInstytucja() {
        return this.instytucja;
    }

    public void setInstytucja(InstytucjaDoplacajaca instytucja) {
        this.instytucja = instytucja;
    }

    public OdpisZwrot getZwrot() {
        return this.zwrot;
    }

    public void setZwrot(OdpisZwrot zwrot) {
        this.zwrot = zwrot;
    }

    public PobieraneSwiadczenie getSwiadczenie() {
        return this.swiadczenie;
    }

    public void setSwiadczenie(PobieraneSwiadczenie swiadczenie) {
        this.swiadczenie = swiadczenie;
    }

    public Osoba getMieszkaniec() {
        return this.mieszkaniec;
    }

    public void setMieszkaniec(Osoba mieszkaniec) {
        this.mieszkaniec = mieszkaniec;
    }

    public Long getMieszkaniecId() {
        return this.mieszkaniecId;
    }

    public void setMieszkaniecId(Long mieszkaniecId) {
        this.mieszkaniecId = mieszkaniecId;
    }

    public Long getOsobaId() {
        return this.osobaId;
    }

    public void setOsobaId(Long osobaId) {
        this.osobaId = osobaId;
    }

    public ZadluzeniePozycja getZadluzeniePozycja() {
        return this.zadluzeniePozycja;
    }

    public void setZadluzeniePozycja(ZadluzeniePozycja zadluzeniePozycja) {
        this.zadluzeniePozycja = zadluzeniePozycja;
    }

    public RodzajZadluzenia getRodzajZadluzenia() {
        return this.rodzajZadluzenia;
    }

    public void setRodzajZadluzenia(RodzajZadluzenia rodzajZadluzenia) {
        this.rodzajZadluzenia = rodzajZadluzenia;
    }
}

