/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.model.main;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import net.karneim.pojobuilder.GeneratePojoBuilder;
import net.sf.jooreports.opendocument.BlokDanych;
import net.sourceforge.stripes.action.FileBean;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import pl.topteam.dps.enums.TypSzablonuWydruku;
import pl.topteam.dps.enums.TypWzorca;
import pl.topteam.dps.model.main.SzablonBlokFtl;

@GeneratePojoBuilder
public class SzablonWydruku
extends pl.topteam.dps.model.main_gen.SzablonWydruku {
    private static final long serialVersionUID = -7157039567465688387L;
    private transient Long id;
    private transient List<SzablonBlokFtl> blokiFtl;
    private String ooSzablonName;
    private transient FileBean ooSzablon;
    private String tresc;

    public String getTrescZBlokamiFtl() {
        String trescTmp = this.getTresc();
        if (StringUtils.isNotEmpty((CharSequence)trescTmp) && this.getBlokiFtl() != null) {
            for (SzablonBlokFtl tmp : this.getBlokiFtl()) {
                trescTmp = trescTmp.replaceAll("#blok" + tmp.getNumerPorzadkowy() + "#", Matcher.quoteReplacement(tmp.getBlok()));
            }
        }
        return trescTmp;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public List<SzablonBlokFtl> getBlokiFtl() {
        return this.blokiFtl;
    }

    public List<BlokDanych> getBlokiDanych() {
        ArrayList<BlokDanych> tmpList = new ArrayList<BlokDanych>();
        if (this.getBlokiFtl() != null) {
            for (SzablonBlokFtl blokFtl : this.getBlokiFtl()) {
                tmpList.add(blokFtl);
            }
        }
        return tmpList;
    }

    public void setBlokiFtl(List<SzablonBlokFtl> blokiFtl) {
        this.blokiFtl = blokiFtl;
    }

    public String getTresc() {
        return this.tresc;
    }

    public void setTresc(String tresc) {
        this.tresc = tresc;
    }

    public FileBean getOoSzablon() {
        return this.ooSzablon;
    }

    public void setOoSzablon(FileBean ooSzablon) {
        this.ooSzablon = ooSzablon;
    }

    public String getOoSzablonName() {
        return this.ooSzablonName;
    }

    public void setOoSzablonName(String ooSzablonName) {
        this.ooSzablonName = ooSzablonName;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SzablonWydruku)) {
            return false;
        }
        SzablonWydruku tmp = (SzablonWydruku)obj;
        return new EqualsBuilder().append((Object)this.getNazwa(), (Object)tmp.getNazwa()).append((Object)this.getTresc(), (Object)tmp.getTresc()).append((Object)this.getTypWzorca(), (Object)tmp.getTypWzorca()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getNazwa()).append((Object)this.getTresc()).append((Object)this.getTypWzorca()).toHashCode();
    }

    Object writeReplace() throws ObjectStreamException {
        return new SzablonWydrukuSerializationProxy(this);
    }

    public static class SzablonWydrukuSerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 5000102035405750159L;
        private String nazwa;
        private String tresc;
        private TypWzorca typWzorca;
        private TypSzablonuWydruku typSzablonu;
        private List<SzablonBlokFtl> blokiFtl;

        public SzablonWydrukuSerializationProxy() {
        }

        public SzablonWydrukuSerializationProxy(SzablonWydruku szablonWydruku) {
            this.nazwa = szablonWydruku.getNazwa();
            this.tresc = szablonWydruku.getTresc();
            this.typWzorca = szablonWydruku.getTypWzorca();
            this.typSzablonu = szablonWydruku.getTypSzablonu();
            this.blokiFtl = szablonWydruku.getBlokiFtl();
        }

        Object readResolve() throws ObjectStreamException {
            SzablonWydruku szablonWydruku = new SzablonWydruku();
            szablonWydruku.setNazwa(this.nazwa);
            szablonWydruku.setTresc(this.tresc);
            szablonWydruku.setTypWzorca(this.typWzorca);
            szablonWydruku.setTypSzablonu(this.typSzablonu);
            if (this.blokiFtl != null) {
                szablonWydruku.setBlokiFtl(this.blokiFtl);
            }
            return szablonWydruku;
        }
    }
}

