/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.security.password.gen;

import com.Ostermiller.util.RandPass;
import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.topteam.security.password.PasswordPreferences;
import pl.topteam.security.password.gen.CharacterGroup;
import pl.topteam.security.password.gen.PasswordVerificationInfo;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static final String GEN_ALGORITHM = "SHA1PRNG";
    private Random random;
    private RandPass randPass;
    private PasswordPreferences preferences;

    public Utils(@Nonnull PasswordPreferences preferences) {
        this.preferences = (PasswordPreferences)Preconditions.checkNotNull((Object)preferences);
        try {
            this.random = SecureRandom.getInstance(GEN_ALGORITHM);
        }
        catch (NoSuchAlgorithmException ex) {
            this.random = new Random();
        }
        this.randPass = new RandPass();
        Map<CharacterGroup, Integer> groupsOfCharacter = preferences.characterGroups();
        if (groupsOfCharacter != null && !groupsOfCharacter.isEmpty()) {
            for (Map.Entry<CharacterGroup, Integer> chGroup : groupsOfCharacter.entrySet()) {
                char[] charArray = chGroup.getKey() == CharacterGroup.CUSTOM ? preferences.customChars().toCharArray() : chGroup.getKey().getCharacters().toCharArray();
                this.randPass.addRequirement(charArray, chGroup.getValue().intValue());
            }
        }
    }

    public String createPassword() {
        int min = this.preferences.min();
        int length = min + this.random.nextInt(this.preferences.max() - min + 1);
        log.debug("password length: " + length);
        return this.randPass.getPass(length);
    }

    public PasswordVerificationInfo verifyPassword(@Nonnull String pass) {
        Preconditions.checkNotNull((Object)pass);
        if (!Range.closed((Comparable)this.preferences.min(), (Comparable)this.preferences.max()).contains((Comparable)Integer.valueOf(pass.toCharArray().length))) {
            return PasswordVerificationInfo.LENGTH;
        }
        if (this.preferences.characterGroups() != null) {
            for (Map.Entry<CharacterGroup, Integer> chGroup : this.preferences.characterGroups().entrySet()) {
                char[] charArray = chGroup.getKey() == CharacterGroup.CUSTOM ? this.preferences.customChars().toCharArray() : chGroup.getKey().getCharacters().toCharArray();
                int numOfChar = 0;
                for (char ch : charArray) {
                    numOfChar += StringUtils.countMatches((CharSequence)pass, (CharSequence)String.valueOf(ch));
                }
                if (numOfChar >= chGroup.getValue()) continue;
                return Enum.valueOf(PasswordVerificationInfo.class, chGroup.getKey().name());
            }
        }
        return null;
    }
}

