package pl.topteam.dps.dao.main;

import java.util.List;
import java.util.Map;

import pl.topteam.dps.model.main.Adres;

public interface AdresMapper extends pl.topteam.dps.dao.main_gen.AdresMapper {

	/**
	 * Zwraca aktualny adres zamieszkania dla wskazanej osoby
	 * 
	 * @param osobaId
	 * @return
	 */
	Adres aktualnyZamieszkania(Long osobaId);
	
	/**
	 * Filtrowanie aktualnych adresow
	 * 
	 * @return
	 */
	List<Adres> filtrAktualnychAdresow(Map<String, Object> filtr);
	
	/**
	 * Filtrowanie adresow
	 * 
	 * @return
	 */
	List<Adres> filtrAdresow(Map<String, Object> filtr);
	
	/**
	 * Usuwanie adresów dla osoby
	 */
	int deleteByOsobaId(Long osobaId);
}
