package pl.topteam.dps.dao.main;

import java.util.Date;
import java.util.List;
import java.util.Map;

import pl.topteam.dps.model.main.Pracownik;

public interface PracownikMapper extends pl.topteam.dps.dao.main_gen.PracownikMapper {
	Integer filtrPracownikowIleWierszy(Map<String, Object> filtr);
	List<Pracownik> filtrPracownikow(Map<String, Object> filtr);
	
	/**
	 * Wyszukuje aktywnego (takiego, któremy wolno się zalogować)
	 * pracownika wg jego loginu
	 * 
	 * @param login
	 * @return
	 */
	Pracownik znajdzAktywnychPoLoginie(String login);
	
	/**
	 * Filtr pracowników którzy mogą się logować
	 * @param filtr
	 * @return
	 */
	List<Pracownik> filtrPracownikowAktywnych(Map<String, Object> filtr);
	
	/**
	 * Resetuje logowania dla użytkowników, którzy logowali się z niepowodzeniem
	 * wcześniej niż wskazana data
	 * 
	 * @param data
	 */
	void resetujAutomatLogowanie(Date data);
	
}
