package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.AdresatSprawozdania;
import pl.topteam.dps.model.main.AdresatSprawozdaniaCriteria;

public abstract interface AdresatSprawozdaniaMapper {
    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=AdresatSprawozdaniaSqlProvider.class, method="countByExample")
    int countByExample(AdresatSprawozdaniaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @DeleteProvider(type=AdresatSprawozdaniaSqlProvider.class, method="deleteByExample")
    int deleteByExample(AdresatSprawozdaniaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Delete({
        "delete from ADRESAT_SPRAWOZDANIA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Insert({
        "insert into ADRESAT_SPRAWOZDANIA (ADRES_ID, KOD_KESO, ",
        "NAZWA, RODZAJ_SPRAWOZDANIA)",
        "values (#{adresId,jdbcType=BIGINT}, #{kodKeso,jdbcType=VARCHAR}, ",
        "#{nazwa,jdbcType=VARCHAR}, #{rodzajSprawozdania,jdbcType=VARCHAR})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(AdresatSprawozdania record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    int mergeInto(AdresatSprawozdania record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @InsertProvider(type=AdresatSprawozdaniaSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(AdresatSprawozdania record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=AdresatSprawozdaniaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="ADRES_ID", property="adresId", jdbcType=JdbcType.BIGINT),
        @Result(column="KOD_KESO", property="kodKeso", jdbcType=JdbcType.VARCHAR),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR),
        @Result(column="RODZAJ_SPRAWOZDANIA", property="rodzajSprawozdania", jdbcType=JdbcType.VARCHAR)
    })
    List<AdresatSprawozdania> selectByExampleWithRowbounds(AdresatSprawozdaniaCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=AdresatSprawozdaniaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="ADRES_ID", property="adresId", jdbcType=JdbcType.BIGINT),
        @Result(column="KOD_KESO", property="kodKeso", jdbcType=JdbcType.VARCHAR),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR),
        @Result(column="RODZAJ_SPRAWOZDANIA", property="rodzajSprawozdania", jdbcType=JdbcType.VARCHAR)
    })
    List<AdresatSprawozdania> selectByExample(AdresatSprawozdaniaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Select({
        "select",
        "ID, ADRES_ID, KOD_KESO, NAZWA, RODZAJ_SPRAWOZDANIA",
        "from ADRESAT_SPRAWOZDANIA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="ADRES_ID", property="adresId", jdbcType=JdbcType.BIGINT),
        @Result(column="KOD_KESO", property="kodKeso", jdbcType=JdbcType.VARCHAR),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR),
        @Result(column="RODZAJ_SPRAWOZDANIA", property="rodzajSprawozdania", jdbcType=JdbcType.VARCHAR)
    })
    AdresatSprawozdania selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=AdresatSprawozdaniaSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") AdresatSprawozdania record, @Param("example") AdresatSprawozdaniaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=AdresatSprawozdaniaSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") AdresatSprawozdania record, @Param("example") AdresatSprawozdaniaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=AdresatSprawozdaniaSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(AdresatSprawozdania record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Update({
        "update ADRESAT_SPRAWOZDANIA",
        "set ADRES_ID = #{adresId,jdbcType=BIGINT},",
          "KOD_KESO = #{kodKeso,jdbcType=VARCHAR},",
          "NAZWA = #{nazwa,jdbcType=VARCHAR},",
          "RODZAJ_SPRAWOZDANIA = #{rodzajSprawozdania,jdbcType=VARCHAR}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(AdresatSprawozdania record);
}