package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.enums.TypAutonumeracji;
import pl.topteam.dps.model.main.Autonumer;
import pl.topteam.dps.model.main.AutonumerCriteria;

public abstract interface AutonumerMapper {
    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=AutonumerSqlProvider.class, method="countByExample")
    int countByExample(AutonumerCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @DeleteProvider(type=AutonumerSqlProvider.class, method="deleteByExample")
    int deleteByExample(AutonumerCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Delete({
        "delete from AUTONUMER",
        "where TYP = #{typ,jdbcType=VARCHAR}"
    })
    int deleteByPrimaryKey(TypAutonumeracji typ);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Insert({
        "insert into AUTONUMER (TYP, FORMAT, ",
        "WARTOSC)",
        "values (#{typ,jdbcType=VARCHAR}, #{format,jdbcType=VARCHAR}, ",
        "#{wartosc,jdbcType=INTEGER})"
    })
    int insert(Autonumer record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    int mergeInto(Autonumer record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @InsertProvider(type=AutonumerSqlProvider.class, method="insertSelective")
    int insertSelective(Autonumer record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=AutonumerSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="TYP", property="typ", jdbcType=JdbcType.VARCHAR, id=true),
        @Result(column="FORMAT", property="format", jdbcType=JdbcType.VARCHAR),
        @Result(column="WARTOSC", property="wartosc", jdbcType=JdbcType.INTEGER)
    })
    List<Autonumer> selectByExampleWithRowbounds(AutonumerCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=AutonumerSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="TYP", property="typ", jdbcType=JdbcType.VARCHAR, id=true),
        @Result(column="FORMAT", property="format", jdbcType=JdbcType.VARCHAR),
        @Result(column="WARTOSC", property="wartosc", jdbcType=JdbcType.INTEGER)
    })
    List<Autonumer> selectByExample(AutonumerCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Select({
        "select",
        "TYP, FORMAT, WARTOSC",
        "from AUTONUMER",
        "where TYP = #{typ,jdbcType=VARCHAR}"
    })
    @Results({
        @Result(column="TYP", property="typ", jdbcType=JdbcType.VARCHAR, id=true),
        @Result(column="FORMAT", property="format", jdbcType=JdbcType.VARCHAR),
        @Result(column="WARTOSC", property="wartosc", jdbcType=JdbcType.INTEGER)
    })
    Autonumer selectByPrimaryKey(TypAutonumeracji typ);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=AutonumerSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") Autonumer record, @Param("example") AutonumerCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=AutonumerSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") Autonumer record, @Param("example") AutonumerCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=AutonumerSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(Autonumer record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Update({
        "update AUTONUMER",
        "set FORMAT = #{format,jdbcType=VARCHAR},",
          "WARTOSC = #{wartosc,jdbcType=INTEGER}",
        "where TYP = #{typ,jdbcType=VARCHAR}"
    })
    int updateByPrimaryKey(Autonumer record);
}