package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.CzynnoscRealizacja;
import pl.topteam.dps.model.main.CzynnoscRealizacjaCriteria;

public abstract interface CzynnoscRealizacjaMapper {
    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=CzynnoscRealizacjaSqlProvider.class, method="countByExample")
    int countByExample(CzynnoscRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @DeleteProvider(type=CzynnoscRealizacjaSqlProvider.class, method="deleteByExample")
    int deleteByExample(CzynnoscRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Delete({
        "delete from CZYNNOSC_REALIZACJA",
        "where CZYNNOSC_ID = #{czynnoscId,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long czynnoscId);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Insert({
        "insert into CZYNNOSC_REALIZACJA (CZYNNOSC_ID, PLAN_WSPARCIA_REALIZACJA_ID)",
        "values (#{czynnoscId,jdbcType=BIGINT}, #{planWsparciaRealizacjaId,jdbcType=BIGINT})"
    })
    int insert(CzynnoscRealizacja record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    int mergeInto(CzynnoscRealizacja record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @InsertProvider(type=CzynnoscRealizacjaSqlProvider.class, method="insertSelective")
    int insertSelective(CzynnoscRealizacja record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=CzynnoscRealizacjaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="CZYNNOSC_ID", property="czynnoscId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="PLAN_WSPARCIA_REALIZACJA_ID", property="planWsparciaRealizacjaId", jdbcType=JdbcType.BIGINT)
    })
    List<CzynnoscRealizacja> selectByExampleWithRowbounds(CzynnoscRealizacjaCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=CzynnoscRealizacjaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="CZYNNOSC_ID", property="czynnoscId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="PLAN_WSPARCIA_REALIZACJA_ID", property="planWsparciaRealizacjaId", jdbcType=JdbcType.BIGINT)
    })
    List<CzynnoscRealizacja> selectByExample(CzynnoscRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Select({
        "select",
        "CZYNNOSC_ID, PLAN_WSPARCIA_REALIZACJA_ID",
        "from CZYNNOSC_REALIZACJA",
        "where CZYNNOSC_ID = #{czynnoscId,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="CZYNNOSC_ID", property="czynnoscId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="PLAN_WSPARCIA_REALIZACJA_ID", property="planWsparciaRealizacjaId", jdbcType=JdbcType.BIGINT)
    })
    CzynnoscRealizacja selectByPrimaryKey(Long czynnoscId);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=CzynnoscRealizacjaSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") CzynnoscRealizacja record, @Param("example") CzynnoscRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=CzynnoscRealizacjaSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") CzynnoscRealizacja record, @Param("example") CzynnoscRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=CzynnoscRealizacjaSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(CzynnoscRealizacja record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Update({
        "update CZYNNOSC_REALIZACJA",
        "set PLAN_WSPARCIA_REALIZACJA_ID = #{planWsparciaRealizacjaId,jdbcType=BIGINT}",
        "where CZYNNOSC_ID = #{czynnoscId,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(CzynnoscRealizacja record);
}