package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.DecyzjaSwiadczenie;
import pl.topteam.dps.model.main_gen.DecyzjaSwiadczenieCriteria.Criteria;
import pl.topteam.dps.model.main_gen.DecyzjaSwiadczenieCriteria.Criterion;
import pl.topteam.dps.model.main.DecyzjaSwiadczenieCriteria;

public class DecyzjaSwiadczenieSqlProvider {

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String countByExample(DecyzjaSwiadczenieCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("DECYZJA_SWIADCZENIE");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String deleteByExample(DecyzjaSwiadczenieCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("DECYZJA_SWIADCZENIE");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String insertSelective(DecyzjaSwiadczenie record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("DECYZJA_SWIADCZENIE");
        
        if (record.getDecyzjaId() != null) {
            sql.VALUES("DECYZJA_ID", "#{decyzjaId,jdbcType=BIGINT}");
        }
        
        if (record.getSwiadczenieId() != null) {
            sql.VALUES("SWIADCZENIE_ID", "#{swiadczenieId,jdbcType=BIGINT}");
        }
        
        if (record.getIloscLimit() != null) {
            sql.VALUES("ILOSC_LIMIT", "#{iloscLimit,jdbcType=DECIMAL}");
        }
        
        if (record.getOkresIloscLimit() != null) {
            sql.VALUES("OKRES_ILOSC_LIMIT", "#{okresIloscLimit,jdbcType=DECIMAL}");
        }
        
        if (record.getOkresLimit() != null) {
            sql.VALUES("OKRES_LIMIT", "#{okresLimit,jdbcType=VARCHAR}");
        }
        
        if (record.getProcentOdplatnosc() != null) {
            sql.VALUES("PROCENT_ODPLATNOSC", "#{procentOdplatnosc,jdbcType=INTEGER}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String selectByExample(DecyzjaSwiadczenieCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("DECYZJA_ID");
        } else {
            sql.SELECT("DECYZJA_ID");
        }
        sql.SELECT("SWIADCZENIE_ID");
        sql.SELECT("ILOSC_LIMIT");
        sql.SELECT("OKRES_ILOSC_LIMIT");
        sql.SELECT("OKRES_LIMIT");
        sql.SELECT("PROCENT_ODPLATNOSC");
        sql.FROM("DECYZJA_SWIADCZENIE");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        DecyzjaSwiadczenie record = (DecyzjaSwiadczenie) parameter.get("record");
        DecyzjaSwiadczenieCriteria example = (DecyzjaSwiadczenieCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("DECYZJA_SWIADCZENIE");
        
        if (record.getDecyzjaId() != null) {
            sql.SET("DECYZJA_ID = #{record.decyzjaId,jdbcType=BIGINT}");
        }
        
        if (record.getSwiadczenieId() != null) {
            sql.SET("SWIADCZENIE_ID = #{record.swiadczenieId,jdbcType=BIGINT}");
        }
        
        if (record.getIloscLimit() != null) {
            sql.SET("ILOSC_LIMIT = #{record.iloscLimit,jdbcType=DECIMAL}");
        }
        
        if (record.getOkresIloscLimit() != null) {
            sql.SET("OKRES_ILOSC_LIMIT = #{record.okresIloscLimit,jdbcType=DECIMAL}");
        }
        
        if (record.getOkresLimit() != null) {
            sql.SET("OKRES_LIMIT = #{record.okresLimit,jdbcType=VARCHAR}");
        }
        
        if (record.getProcentOdplatnosc() != null) {
            sql.SET("PROCENT_ODPLATNOSC = #{record.procentOdplatnosc,jdbcType=INTEGER}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("DECYZJA_SWIADCZENIE");
        
        sql.SET("DECYZJA_ID = #{record.decyzjaId,jdbcType=BIGINT}");
        sql.SET("SWIADCZENIE_ID = #{record.swiadczenieId,jdbcType=BIGINT}");
        sql.SET("ILOSC_LIMIT = #{record.iloscLimit,jdbcType=DECIMAL}");
        sql.SET("OKRES_ILOSC_LIMIT = #{record.okresIloscLimit,jdbcType=DECIMAL}");
        sql.SET("OKRES_LIMIT = #{record.okresLimit,jdbcType=VARCHAR}");
        sql.SET("PROCENT_ODPLATNOSC = #{record.procentOdplatnosc,jdbcType=INTEGER}");
        
        DecyzjaSwiadczenieCriteria example = (DecyzjaSwiadczenieCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByPrimaryKeySelective(DecyzjaSwiadczenie record) {
        SQL sql = new SQL();
        sql.UPDATE("DECYZJA_SWIADCZENIE");
        
        if (record.getIloscLimit() != null) {
            sql.SET("ILOSC_LIMIT = #{iloscLimit,jdbcType=DECIMAL}");
        }
        
        if (record.getOkresIloscLimit() != null) {
            sql.SET("OKRES_ILOSC_LIMIT = #{okresIloscLimit,jdbcType=DECIMAL}");
        }
        
        if (record.getOkresLimit() != null) {
            sql.SET("OKRES_LIMIT = #{okresLimit,jdbcType=VARCHAR}");
        }
        
        if (record.getProcentOdplatnosc() != null) {
            sql.SET("PROCENT_ODPLATNOSC = #{procentOdplatnosc,jdbcType=INTEGER}");
        }
        
        sql.WHERE("DECYZJA_ID = #{decyzjaId,jdbcType=BIGINT}");
        sql.WHERE("SWIADCZENIE_ID = #{swiadczenieId,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    protected void applyWhere(SQL sql, DecyzjaSwiadczenieCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}