package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.Diagnoza;
import pl.topteam.dps.model.main.DiagnozaCriteria;

public abstract interface DiagnozaMapper {
    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=DiagnozaSqlProvider.class, method="countByExample")
    int countByExample(DiagnozaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @DeleteProvider(type=DiagnozaSqlProvider.class, method="deleteByExample")
    int deleteByExample(DiagnozaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Delete({
        "delete from DIAGNOZA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Insert({
        "insert into DIAGNOZA (SLOWO_ID, STATUS)",
        "values (#{slowoId,jdbcType=BIGINT}, #{status,jdbcType=VARCHAR})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(Diagnoza record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    int mergeInto(Diagnoza record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @InsertProvider(type=DiagnozaSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(Diagnoza record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=DiagnozaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="SLOWO_ID", property="slowoId", jdbcType=JdbcType.BIGINT),
        @Result(column="STATUS", property="status", jdbcType=JdbcType.VARCHAR)
    })
    List<Diagnoza> selectByExampleWithRowbounds(DiagnozaCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=DiagnozaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="SLOWO_ID", property="slowoId", jdbcType=JdbcType.BIGINT),
        @Result(column="STATUS", property="status", jdbcType=JdbcType.VARCHAR)
    })
    List<Diagnoza> selectByExample(DiagnozaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Select({
        "select",
        "ID, SLOWO_ID, STATUS",
        "from DIAGNOZA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="SLOWO_ID", property="slowoId", jdbcType=JdbcType.BIGINT),
        @Result(column="STATUS", property="status", jdbcType=JdbcType.VARCHAR)
    })
    Diagnoza selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=DiagnozaSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") Diagnoza record, @Param("example") DiagnozaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=DiagnozaSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") Diagnoza record, @Param("example") DiagnozaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=DiagnozaSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(Diagnoza record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Update({
        "update DIAGNOZA",
        "set SLOWO_ID = #{slowoId,jdbcType=BIGINT},",
          "STATUS = #{status,jdbcType=VARCHAR}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(Diagnoza record);
}