package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.Faktura;
import pl.topteam.dps.model.main_gen.FakturaCriteria.Criteria;
import pl.topteam.dps.model.main_gen.FakturaCriteria.Criterion;
import pl.topteam.dps.model.main.FakturaCriteria;

public class FakturaSqlProvider {

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String countByExample(FakturaCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("FAKTURA");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String deleteByExample(FakturaCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("FAKTURA");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String insertSelective(Faktura record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("FAKTURA");
        
        if (record.getOsobaId() != null) {
            sql.VALUES("OSOBA_ID", "#{osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getPracownikWprowadzil() != null) {
            sql.VALUES("PRACOWNIK_WPROWADZIL", "#{pracownikWprowadzil,jdbcType=BIGINT}");
        }
        
        if (record.getUmowaAptekaKwotaId() != null) {
            sql.VALUES("UMOWA_APTEKA_KWOTA_ID", "#{umowaAptekaKwotaId,jdbcType=BIGINT}");
        }
        
        if (record.getDataWystawienia() != null) {
            sql.VALUES("DATA_WYSTAWIENIA", "#{dataWystawienia,jdbcType=DATE}");
        }
        
        if (record.getDataWprowadzenia() != null) {
            sql.VALUES("DATA_WPROWADZENIA", "#{dataWprowadzenia,jdbcType=DATE}");
        }
        
        if (record.getKwotaDom() != null) {
            sql.VALUES("KWOTA_DOM", "#{kwotaDom,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaM() != null) {
            sql.VALUES("KWOTA_M", "#{kwotaM,jdbcType=DECIMAL}");
        }
        
        if (record.getNr() != null) {
            sql.VALUES("NR", "#{nr,jdbcType=VARCHAR}");
        }
        
        if (record.getStatus() != null) {
            sql.VALUES("STATUS", "#{status,jdbcType=VARCHAR}");
        }
        
        if (record.getNrWew() != null) {
            sql.VALUES("NR_WEW", "#{nrWew,jdbcType=VARCHAR}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String selectByExample(FakturaCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("OSOBA_ID");
        sql.SELECT("PRACOWNIK_WPROWADZIL");
        sql.SELECT("UMOWA_APTEKA_KWOTA_ID");
        sql.SELECT("DATA_WYSTAWIENIA");
        sql.SELECT("DATA_WPROWADZENIA");
        sql.SELECT("KWOTA_DOM");
        sql.SELECT("KWOTA_M");
        sql.SELECT("NR");
        sql.SELECT("STATUS");
        sql.SELECT("NR_WEW");
        sql.FROM("FAKTURA");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        Faktura record = (Faktura) parameter.get("record");
        FakturaCriteria example = (FakturaCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("FAKTURA");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getOsobaId() != null) {
            sql.SET("OSOBA_ID = #{record.osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getPracownikWprowadzil() != null) {
            sql.SET("PRACOWNIK_WPROWADZIL = #{record.pracownikWprowadzil,jdbcType=BIGINT}");
        }
        
        if (record.getUmowaAptekaKwotaId() != null) {
            sql.SET("UMOWA_APTEKA_KWOTA_ID = #{record.umowaAptekaKwotaId,jdbcType=BIGINT}");
        }
        
        if (record.getDataWystawienia() != null) {
            sql.SET("DATA_WYSTAWIENIA = #{record.dataWystawienia,jdbcType=DATE}");
        }
        
        if (record.getDataWprowadzenia() != null) {
            sql.SET("DATA_WPROWADZENIA = #{record.dataWprowadzenia,jdbcType=DATE}");
        }
        
        if (record.getKwotaDom() != null) {
            sql.SET("KWOTA_DOM = #{record.kwotaDom,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaM() != null) {
            sql.SET("KWOTA_M = #{record.kwotaM,jdbcType=DECIMAL}");
        }
        
        if (record.getNr() != null) {
            sql.SET("NR = #{record.nr,jdbcType=VARCHAR}");
        }
        
        if (record.getStatus() != null) {
            sql.SET("STATUS = #{record.status,jdbcType=VARCHAR}");
        }
        
        if (record.getNrWew() != null) {
            sql.SET("NR_WEW = #{record.nrWew,jdbcType=VARCHAR}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("FAKTURA");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("OSOBA_ID = #{record.osobaId,jdbcType=BIGINT}");
        sql.SET("PRACOWNIK_WPROWADZIL = #{record.pracownikWprowadzil,jdbcType=BIGINT}");
        sql.SET("UMOWA_APTEKA_KWOTA_ID = #{record.umowaAptekaKwotaId,jdbcType=BIGINT}");
        sql.SET("DATA_WYSTAWIENIA = #{record.dataWystawienia,jdbcType=DATE}");
        sql.SET("DATA_WPROWADZENIA = #{record.dataWprowadzenia,jdbcType=DATE}");
        sql.SET("KWOTA_DOM = #{record.kwotaDom,jdbcType=DECIMAL}");
        sql.SET("KWOTA_M = #{record.kwotaM,jdbcType=DECIMAL}");
        sql.SET("NR = #{record.nr,jdbcType=VARCHAR}");
        sql.SET("STATUS = #{record.status,jdbcType=VARCHAR}");
        sql.SET("NR_WEW = #{record.nrWew,jdbcType=VARCHAR}");
        
        FakturaCriteria example = (FakturaCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByPrimaryKeySelective(Faktura record) {
        SQL sql = new SQL();
        sql.UPDATE("FAKTURA");
        
        if (record.getOsobaId() != null) {
            sql.SET("OSOBA_ID = #{osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getPracownikWprowadzil() != null) {
            sql.SET("PRACOWNIK_WPROWADZIL = #{pracownikWprowadzil,jdbcType=BIGINT}");
        }
        
        if (record.getUmowaAptekaKwotaId() != null) {
            sql.SET("UMOWA_APTEKA_KWOTA_ID = #{umowaAptekaKwotaId,jdbcType=BIGINT}");
        }
        
        if (record.getDataWystawienia() != null) {
            sql.SET("DATA_WYSTAWIENIA = #{dataWystawienia,jdbcType=DATE}");
        }
        
        if (record.getDataWprowadzenia() != null) {
            sql.SET("DATA_WPROWADZENIA = #{dataWprowadzenia,jdbcType=DATE}");
        }
        
        if (record.getKwotaDom() != null) {
            sql.SET("KWOTA_DOM = #{kwotaDom,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaM() != null) {
            sql.SET("KWOTA_M = #{kwotaM,jdbcType=DECIMAL}");
        }
        
        if (record.getNr() != null) {
            sql.SET("NR = #{nr,jdbcType=VARCHAR}");
        }
        
        if (record.getStatus() != null) {
            sql.SET("STATUS = #{status,jdbcType=VARCHAR}");
        }
        
        if (record.getNrWew() != null) {
            sql.SET("NR_WEW = #{nrWew,jdbcType=VARCHAR}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    protected void applyWhere(SQL sql, FakturaCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}