package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.FormatCsv;
import pl.topteam.dps.model.main_gen.FormatCsvCriteria.Criteria;
import pl.topteam.dps.model.main_gen.FormatCsvCriteria.Criterion;
import pl.topteam.dps.model.main.FormatCsvCriteria;

public class FormatCsvSqlProvider {

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String countByExample(FormatCsvCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("FORMAT_CSV");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String deleteByExample(FormatCsvCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("FORMAT_CSV");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String insertSelective(FormatCsv record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("FORMAT_CSV");
        
        if (record.getCharset() != null) {
            sql.VALUES("CHARSET", "#{charset,jdbcType=VARCHAR}");
        }
        
        if (record.getLiniaOpisow() != null) {
            sql.VALUES("LINIA_OPISOW", "#{liniaOpisow,jdbcType=BOOLEAN}");
        }
        
        if (record.getNazwa() != null) {
            sql.VALUES("NAZWA", "#{nazwa,jdbcType=VARCHAR}");
        }
        
        if (record.getSeparatorPola() != null) {
            sql.VALUES("SEPARATOR_POLA", "#{separatorPola,jdbcType=VARCHAR}");
        }
        
        if (record.getSeparatorWiersza() != null) {
            sql.VALUES("SEPARATOR_WIERSZA", "#{separatorWiersza,jdbcType=VARCHAR}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String selectByExample(FormatCsvCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("CHARSET");
        sql.SELECT("LINIA_OPISOW");
        sql.SELECT("NAZWA");
        sql.SELECT("SEPARATOR_POLA");
        sql.SELECT("SEPARATOR_WIERSZA");
        sql.FROM("FORMAT_CSV");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        FormatCsv record = (FormatCsv) parameter.get("record");
        FormatCsvCriteria example = (FormatCsvCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("FORMAT_CSV");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getCharset() != null) {
            sql.SET("CHARSET = #{record.charset,jdbcType=VARCHAR}");
        }
        
        if (record.getLiniaOpisow() != null) {
            sql.SET("LINIA_OPISOW = #{record.liniaOpisow,jdbcType=BOOLEAN}");
        }
        
        if (record.getNazwa() != null) {
            sql.SET("NAZWA = #{record.nazwa,jdbcType=VARCHAR}");
        }
        
        if (record.getSeparatorPola() != null) {
            sql.SET("SEPARATOR_POLA = #{record.separatorPola,jdbcType=VARCHAR}");
        }
        
        if (record.getSeparatorWiersza() != null) {
            sql.SET("SEPARATOR_WIERSZA = #{record.separatorWiersza,jdbcType=VARCHAR}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("FORMAT_CSV");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("CHARSET = #{record.charset,jdbcType=VARCHAR}");
        sql.SET("LINIA_OPISOW = #{record.liniaOpisow,jdbcType=BOOLEAN}");
        sql.SET("NAZWA = #{record.nazwa,jdbcType=VARCHAR}");
        sql.SET("SEPARATOR_POLA = #{record.separatorPola,jdbcType=VARCHAR}");
        sql.SET("SEPARATOR_WIERSZA = #{record.separatorWiersza,jdbcType=VARCHAR}");
        
        FormatCsvCriteria example = (FormatCsvCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByPrimaryKeySelective(FormatCsv record) {
        SQL sql = new SQL();
        sql.UPDATE("FORMAT_CSV");
        
        if (record.getCharset() != null) {
            sql.SET("CHARSET = #{charset,jdbcType=VARCHAR}");
        }
        
        if (record.getLiniaOpisow() != null) {
            sql.SET("LINIA_OPISOW = #{liniaOpisow,jdbcType=BOOLEAN}");
        }
        
        if (record.getNazwa() != null) {
            sql.SET("NAZWA = #{nazwa,jdbcType=VARCHAR}");
        }
        
        if (record.getSeparatorPola() != null) {
            sql.SET("SEPARATOR_POLA = #{separatorPola,jdbcType=VARCHAR}");
        }
        
        if (record.getSeparatorWiersza() != null) {
            sql.SET("SEPARATOR_WIERSZA = #{separatorWiersza,jdbcType=VARCHAR}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    protected void applyWhere(SQL sql, FormatCsvCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}