package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.KatUslCzynnosc;
import pl.topteam.dps.model.main_gen.KatUslCzynnoscCriteria.Criteria;
import pl.topteam.dps.model.main_gen.KatUslCzynnoscCriteria.Criterion;
import pl.topteam.dps.model.main.KatUslCzynnoscCriteria;

public class KatUslCzynnoscSqlProvider {

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String countByExample(KatUslCzynnoscCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("KAT_USL_CZYNNOSC");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String deleteByExample(KatUslCzynnoscCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("KAT_USL_CZYNNOSC");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String insertSelective(KatUslCzynnosc record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("KAT_USL_CZYNNOSC");
        
        if (record.getKategoriaId() != null) {
            sql.VALUES("KATEGORIA_ID", "#{kategoriaId,jdbcType=BIGINT}");
        }
        
        if (record.getDataOd() != null) {
            sql.VALUES("DATA_OD", "#{dataOd,jdbcType=DATE}");
        }
        
        if (record.getDataDo() != null) {
            sql.VALUES("DATA_DO", "#{dataDo,jdbcType=DATE}");
        }
        
        if (record.getKolejnosc() != null) {
            sql.VALUES("KOLEJNOSC", "#{kolejnosc,jdbcType=INTEGER}");
        }
        
        if (record.getNazwa() != null) {
            sql.VALUES("NAZWA", "#{nazwa,jdbcType=VARCHAR}");
        }
        
        if (record.getOpis() != null) {
            sql.VALUES("OPIS", "#{opis,jdbcType=VARCHAR}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String selectByExample(KatUslCzynnoscCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("KATEGORIA_ID");
        sql.SELECT("DATA_OD");
        sql.SELECT("DATA_DO");
        sql.SELECT("KOLEJNOSC");
        sql.SELECT("NAZWA");
        sql.SELECT("OPIS");
        sql.FROM("KAT_USL_CZYNNOSC");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        KatUslCzynnosc record = (KatUslCzynnosc) parameter.get("record");
        KatUslCzynnoscCriteria example = (KatUslCzynnoscCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("KAT_USL_CZYNNOSC");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getKategoriaId() != null) {
            sql.SET("KATEGORIA_ID = #{record.kategoriaId,jdbcType=BIGINT}");
        }
        
        if (record.getDataOd() != null) {
            sql.SET("DATA_OD = #{record.dataOd,jdbcType=DATE}");
        }
        
        if (record.getDataDo() != null) {
            sql.SET("DATA_DO = #{record.dataDo,jdbcType=DATE}");
        }
        
        if (record.getKolejnosc() != null) {
            sql.SET("KOLEJNOSC = #{record.kolejnosc,jdbcType=INTEGER}");
        }
        
        if (record.getNazwa() != null) {
            sql.SET("NAZWA = #{record.nazwa,jdbcType=VARCHAR}");
        }
        
        if (record.getOpis() != null) {
            sql.SET("OPIS = #{record.opis,jdbcType=VARCHAR}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("KAT_USL_CZYNNOSC");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("KATEGORIA_ID = #{record.kategoriaId,jdbcType=BIGINT}");
        sql.SET("DATA_OD = #{record.dataOd,jdbcType=DATE}");
        sql.SET("DATA_DO = #{record.dataDo,jdbcType=DATE}");
        sql.SET("KOLEJNOSC = #{record.kolejnosc,jdbcType=INTEGER}");
        sql.SET("NAZWA = #{record.nazwa,jdbcType=VARCHAR}");
        sql.SET("OPIS = #{record.opis,jdbcType=VARCHAR}");
        
        KatUslCzynnoscCriteria example = (KatUslCzynnoscCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByPrimaryKeySelective(KatUslCzynnosc record) {
        SQL sql = new SQL();
        sql.UPDATE("KAT_USL_CZYNNOSC");
        
        if (record.getKategoriaId() != null) {
            sql.SET("KATEGORIA_ID = #{kategoriaId,jdbcType=BIGINT}");
        }
        
        if (record.getDataOd() != null) {
            sql.SET("DATA_OD = #{dataOd,jdbcType=DATE}");
        }
        
        if (record.getDataDo() != null) {
            sql.SET("DATA_DO = #{dataDo,jdbcType=DATE}");
        }
        
        if (record.getKolejnosc() != null) {
            sql.SET("KOLEJNOSC = #{kolejnosc,jdbcType=INTEGER}");
        }
        
        if (record.getNazwa() != null) {
            sql.SET("NAZWA = #{nazwa,jdbcType=VARCHAR}");
        }
        
        if (record.getOpis() != null) {
            sql.SET("OPIS = #{opis,jdbcType=VARCHAR}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    protected void applyWhere(SQL sql, KatUslCzynnoscCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}