package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.LekRealizacja;
import pl.topteam.dps.model.main.LekRealizacjaCriteria;
import pl.topteam.dps.model.main_gen.LekRealizacjaKey;

public abstract interface LekRealizacjaMapper {
    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=LekRealizacjaSqlProvider.class, method="countByExample")
    int countByExample(LekRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @DeleteProvider(type=LekRealizacjaSqlProvider.class, method="deleteByExample")
    int deleteByExample(LekRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Delete({
        "delete from LEK_REALIZACJA",
        "where REALIZACJA_RECEPTA_ID = #{realizacjaReceptaId,jdbcType=BIGINT}",
          "and KOD_BAZYL = #{kodBazyl,jdbcType=BIGINT}",
          "and NIEZREALIZOWANY = #{niezrealizowany,jdbcType=BOOLEAN}"
    })
    int deleteByPrimaryKey(LekRealizacjaKey key);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Insert({
        "insert into LEK_REALIZACJA (REALIZACJA_RECEPTA_ID, KOD_BAZYL, ",
        "NIEZREALIZOWANY, SLOWO_ID, ",
        "LICZBA_OPAKOWAN, DATA)",
        "values (#{realizacjaReceptaId,jdbcType=BIGINT}, #{kodBazyl,jdbcType=BIGINT}, ",
        "#{niezrealizowany,jdbcType=BOOLEAN}, #{slowoId,jdbcType=BIGINT}, ",
        "#{liczbaOpakowan,jdbcType=INTEGER}, #{data,jdbcType=DATE})"
    })
    int insert(LekRealizacja record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    int mergeInto(LekRealizacja record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @InsertProvider(type=LekRealizacjaSqlProvider.class, method="insertSelective")
    int insertSelective(LekRealizacja record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=LekRealizacjaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="REALIZACJA_RECEPTA_ID", property="realizacjaReceptaId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="KOD_BAZYL", property="kodBazyl", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="NIEZREALIZOWANY", property="niezrealizowany", jdbcType=JdbcType.BOOLEAN, id=true),
        @Result(column="SLOWO_ID", property="slowoId", jdbcType=JdbcType.BIGINT),
        @Result(column="LICZBA_OPAKOWAN", property="liczbaOpakowan", jdbcType=JdbcType.INTEGER),
        @Result(column="DATA", property="data", jdbcType=JdbcType.DATE)
    })
    List<LekRealizacja> selectByExampleWithRowbounds(LekRealizacjaCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=LekRealizacjaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="REALIZACJA_RECEPTA_ID", property="realizacjaReceptaId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="KOD_BAZYL", property="kodBazyl", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="NIEZREALIZOWANY", property="niezrealizowany", jdbcType=JdbcType.BOOLEAN, id=true),
        @Result(column="SLOWO_ID", property="slowoId", jdbcType=JdbcType.BIGINT),
        @Result(column="LICZBA_OPAKOWAN", property="liczbaOpakowan", jdbcType=JdbcType.INTEGER),
        @Result(column="DATA", property="data", jdbcType=JdbcType.DATE)
    })
    List<LekRealizacja> selectByExample(LekRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Select({
        "select",
        "REALIZACJA_RECEPTA_ID, KOD_BAZYL, NIEZREALIZOWANY, SLOWO_ID, LICZBA_OPAKOWAN, ",
        "DATA",
        "from LEK_REALIZACJA",
        "where REALIZACJA_RECEPTA_ID = #{realizacjaReceptaId,jdbcType=BIGINT}",
          "and KOD_BAZYL = #{kodBazyl,jdbcType=BIGINT}",
          "and NIEZREALIZOWANY = #{niezrealizowany,jdbcType=BOOLEAN}"
    })
    @Results({
        @Result(column="REALIZACJA_RECEPTA_ID", property="realizacjaReceptaId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="KOD_BAZYL", property="kodBazyl", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="NIEZREALIZOWANY", property="niezrealizowany", jdbcType=JdbcType.BOOLEAN, id=true),
        @Result(column="SLOWO_ID", property="slowoId", jdbcType=JdbcType.BIGINT),
        @Result(column="LICZBA_OPAKOWAN", property="liczbaOpakowan", jdbcType=JdbcType.INTEGER),
        @Result(column="DATA", property="data", jdbcType=JdbcType.DATE)
    })
    LekRealizacja selectByPrimaryKey(LekRealizacjaKey key);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=LekRealizacjaSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") LekRealizacja record, @Param("example") LekRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=LekRealizacjaSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") LekRealizacja record, @Param("example") LekRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=LekRealizacjaSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(LekRealizacja record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Update({
        "update LEK_REALIZACJA",
        "set SLOWO_ID = #{slowoId,jdbcType=BIGINT},",
          "LICZBA_OPAKOWAN = #{liczbaOpakowan,jdbcType=INTEGER},",
          "DATA = #{data,jdbcType=DATE}",
        "where REALIZACJA_RECEPTA_ID = #{realizacjaReceptaId,jdbcType=BIGINT}",
          "and KOD_BAZYL = #{kodBazyl,jdbcType=BIGINT}",
          "and NIEZREALIZOWANY = #{niezrealizowany,jdbcType=BOOLEAN}"
    })
    int updateByPrimaryKey(LekRealizacja record);
}