package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.Osoba;
import pl.topteam.dps.model.main.OsobaCriteria;

public abstract interface OsobaMapper {
    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=OsobaSqlProvider.class, method="countByExample")
    int countByExample(OsobaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @DeleteProvider(type=OsobaSqlProvider.class, method="deleteByExample")
    int deleteByExample(OsobaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Delete({
        "delete from OSOBA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Insert({
        "insert into OSOBA (STAN_CYWILNY_ID, DATA_URODZENIA, ",
        "IMIE, IMIE_DRUGIE, ",
        "IMIE_MATKI, IMIE_OJCA, ",
        "IMIE_WSPOLMALZONKA, IMPORT_PROGRAM, ",
        "MIEJSCE_URODZENIA, NAZWISKO, ",
        "NAZWISKO_RODOWE, NAZWISKO_RODOWE_MATKI, ",
        "NAZWISKO_WSPOLMALZONKA, NIP, ",
        "PESEL, PLEC, TELEFON_KOM, ",
        "WYZNANIE_ID, WYKSZTALCENIE_ID, ",
        "DATA_ZGONU)",
        "values (#{stanCywilnyId,jdbcType=BIGINT}, #{dataUrodzenia,jdbcType=DATE}, ",
        "#{imie,jdbcType=VARCHAR}, #{imieDrugie,jdbcType=VARCHAR}, ",
        "#{imieMatki,jdbcType=VARCHAR}, #{imieOjca,jdbcType=VARCHAR}, ",
        "#{imieWspolmalzonka,jdbcType=VARCHAR}, #{importProgram,jdbcType=VARCHAR}, ",
        "#{miejsceUrodzenia,jdbcType=VARCHAR}, #{nazwisko,jdbcType=VARCHAR}, ",
        "#{nazwiskoRodowe,jdbcType=VARCHAR}, #{nazwiskoRodoweMatki,jdbcType=VARCHAR}, ",
        "#{nazwiskoWspolmalzonka,jdbcType=VARCHAR}, #{nip,jdbcType=VARCHAR}, ",
        "#{pesel,jdbcType=VARCHAR}, #{plec,jdbcType=VARCHAR}, #{telefonKom,jdbcType=VARCHAR}, ",
        "#{wyznanieId,jdbcType=BIGINT}, #{wyksztalcenieId,jdbcType=BIGINT}, ",
        "#{dataZgonu,jdbcType=DATE})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(Osoba record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    int mergeInto(Osoba record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @InsertProvider(type=OsobaSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(Osoba record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=OsobaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="STAN_CYWILNY_ID", property="stanCywilnyId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_URODZENIA", property="dataUrodzenia", jdbcType=JdbcType.DATE),
        @Result(column="IMIE", property="imie", jdbcType=JdbcType.VARCHAR),
        @Result(column="IMIE_DRUGIE", property="imieDrugie", jdbcType=JdbcType.VARCHAR),
        @Result(column="IMIE_MATKI", property="imieMatki", jdbcType=JdbcType.VARCHAR),
        @Result(column="IMIE_OJCA", property="imieOjca", jdbcType=JdbcType.VARCHAR),
        @Result(column="IMIE_WSPOLMALZONKA", property="imieWspolmalzonka", jdbcType=JdbcType.VARCHAR),
        @Result(column="IMPORT_PROGRAM", property="importProgram", jdbcType=JdbcType.VARCHAR),
        @Result(column="MIEJSCE_URODZENIA", property="miejsceUrodzenia", jdbcType=JdbcType.VARCHAR),
        @Result(column="NAZWISKO", property="nazwisko", jdbcType=JdbcType.VARCHAR),
        @Result(column="NAZWISKO_RODOWE", property="nazwiskoRodowe", jdbcType=JdbcType.VARCHAR),
        @Result(column="NAZWISKO_RODOWE_MATKI", property="nazwiskoRodoweMatki", jdbcType=JdbcType.VARCHAR),
        @Result(column="NAZWISKO_WSPOLMALZONKA", property="nazwiskoWspolmalzonka", jdbcType=JdbcType.VARCHAR),
        @Result(column="NIP", property="nip", jdbcType=JdbcType.VARCHAR),
        @Result(column="PESEL", property="pesel", jdbcType=JdbcType.VARCHAR),
        @Result(column="PLEC", property="plec", jdbcType=JdbcType.VARCHAR),
        @Result(column="TELEFON_KOM", property="telefonKom", jdbcType=JdbcType.VARCHAR),
        @Result(column="WYZNANIE_ID", property="wyznanieId", jdbcType=JdbcType.BIGINT),
        @Result(column="WYKSZTALCENIE_ID", property="wyksztalcenieId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_ZGONU", property="dataZgonu", jdbcType=JdbcType.DATE)
    })
    List<Osoba> selectByExampleWithRowbounds(OsobaCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=OsobaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="STAN_CYWILNY_ID", property="stanCywilnyId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_URODZENIA", property="dataUrodzenia", jdbcType=JdbcType.DATE),
        @Result(column="IMIE", property="imie", jdbcType=JdbcType.VARCHAR),
        @Result(column="IMIE_DRUGIE", property="imieDrugie", jdbcType=JdbcType.VARCHAR),
        @Result(column="IMIE_MATKI", property="imieMatki", jdbcType=JdbcType.VARCHAR),
        @Result(column="IMIE_OJCA", property="imieOjca", jdbcType=JdbcType.VARCHAR),
        @Result(column="IMIE_WSPOLMALZONKA", property="imieWspolmalzonka", jdbcType=JdbcType.VARCHAR),
        @Result(column="IMPORT_PROGRAM", property="importProgram", jdbcType=JdbcType.VARCHAR),
        @Result(column="MIEJSCE_URODZENIA", property="miejsceUrodzenia", jdbcType=JdbcType.VARCHAR),
        @Result(column="NAZWISKO", property="nazwisko", jdbcType=JdbcType.VARCHAR),
        @Result(column="NAZWISKO_RODOWE", property="nazwiskoRodowe", jdbcType=JdbcType.VARCHAR),
        @Result(column="NAZWISKO_RODOWE_MATKI", property="nazwiskoRodoweMatki", jdbcType=JdbcType.VARCHAR),
        @Result(column="NAZWISKO_WSPOLMALZONKA", property="nazwiskoWspolmalzonka", jdbcType=JdbcType.VARCHAR),
        @Result(column="NIP", property="nip", jdbcType=JdbcType.VARCHAR),
        @Result(column="PESEL", property="pesel", jdbcType=JdbcType.VARCHAR),
        @Result(column="PLEC", property="plec", jdbcType=JdbcType.VARCHAR),
        @Result(column="TELEFON_KOM", property="telefonKom", jdbcType=JdbcType.VARCHAR),
        @Result(column="WYZNANIE_ID", property="wyznanieId", jdbcType=JdbcType.BIGINT),
        @Result(column="WYKSZTALCENIE_ID", property="wyksztalcenieId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_ZGONU", property="dataZgonu", jdbcType=JdbcType.DATE)
    })
    List<Osoba> selectByExample(OsobaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Select({
        "select",
        "ID, STAN_CYWILNY_ID, DATA_URODZENIA, IMIE, IMIE_DRUGIE, IMIE_MATKI, IMIE_OJCA, ",
        "IMIE_WSPOLMALZONKA, IMPORT_PROGRAM, MIEJSCE_URODZENIA, NAZWISKO, NAZWISKO_RODOWE, ",
        "NAZWISKO_RODOWE_MATKI, NAZWISKO_WSPOLMALZONKA, NIP, PESEL, PLEC, TELEFON_KOM, ",
        "WYZNANIE_ID, WYKSZTALCENIE_ID, DATA_ZGONU",
        "from OSOBA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="STAN_CYWILNY_ID", property="stanCywilnyId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_URODZENIA", property="dataUrodzenia", jdbcType=JdbcType.DATE),
        @Result(column="IMIE", property="imie", jdbcType=JdbcType.VARCHAR),
        @Result(column="IMIE_DRUGIE", property="imieDrugie", jdbcType=JdbcType.VARCHAR),
        @Result(column="IMIE_MATKI", property="imieMatki", jdbcType=JdbcType.VARCHAR),
        @Result(column="IMIE_OJCA", property="imieOjca", jdbcType=JdbcType.VARCHAR),
        @Result(column="IMIE_WSPOLMALZONKA", property="imieWspolmalzonka", jdbcType=JdbcType.VARCHAR),
        @Result(column="IMPORT_PROGRAM", property="importProgram", jdbcType=JdbcType.VARCHAR),
        @Result(column="MIEJSCE_URODZENIA", property="miejsceUrodzenia", jdbcType=JdbcType.VARCHAR),
        @Result(column="NAZWISKO", property="nazwisko", jdbcType=JdbcType.VARCHAR),
        @Result(column="NAZWISKO_RODOWE", property="nazwiskoRodowe", jdbcType=JdbcType.VARCHAR),
        @Result(column="NAZWISKO_RODOWE_MATKI", property="nazwiskoRodoweMatki", jdbcType=JdbcType.VARCHAR),
        @Result(column="NAZWISKO_WSPOLMALZONKA", property="nazwiskoWspolmalzonka", jdbcType=JdbcType.VARCHAR),
        @Result(column="NIP", property="nip", jdbcType=JdbcType.VARCHAR),
        @Result(column="PESEL", property="pesel", jdbcType=JdbcType.VARCHAR),
        @Result(column="PLEC", property="plec", jdbcType=JdbcType.VARCHAR),
        @Result(column="TELEFON_KOM", property="telefonKom", jdbcType=JdbcType.VARCHAR),
        @Result(column="WYZNANIE_ID", property="wyznanieId", jdbcType=JdbcType.BIGINT),
        @Result(column="WYKSZTALCENIE_ID", property="wyksztalcenieId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_ZGONU", property="dataZgonu", jdbcType=JdbcType.DATE)
    })
    Osoba selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=OsobaSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") Osoba record, @Param("example") OsobaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=OsobaSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") Osoba record, @Param("example") OsobaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=OsobaSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(Osoba record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Update({
        "update OSOBA",
        "set STAN_CYWILNY_ID = #{stanCywilnyId,jdbcType=BIGINT},",
          "DATA_URODZENIA = #{dataUrodzenia,jdbcType=DATE},",
          "IMIE = #{imie,jdbcType=VARCHAR},",
          "IMIE_DRUGIE = #{imieDrugie,jdbcType=VARCHAR},",
          "IMIE_MATKI = #{imieMatki,jdbcType=VARCHAR},",
          "IMIE_OJCA = #{imieOjca,jdbcType=VARCHAR},",
          "IMIE_WSPOLMALZONKA = #{imieWspolmalzonka,jdbcType=VARCHAR},",
          "IMPORT_PROGRAM = #{importProgram,jdbcType=VARCHAR},",
          "MIEJSCE_URODZENIA = #{miejsceUrodzenia,jdbcType=VARCHAR},",
          "NAZWISKO = #{nazwisko,jdbcType=VARCHAR},",
          "NAZWISKO_RODOWE = #{nazwiskoRodowe,jdbcType=VARCHAR},",
          "NAZWISKO_RODOWE_MATKI = #{nazwiskoRodoweMatki,jdbcType=VARCHAR},",
          "NAZWISKO_WSPOLMALZONKA = #{nazwiskoWspolmalzonka,jdbcType=VARCHAR},",
          "NIP = #{nip,jdbcType=VARCHAR},",
          "PESEL = #{pesel,jdbcType=VARCHAR},",
          "PLEC = #{plec,jdbcType=VARCHAR},",
          "TELEFON_KOM = #{telefonKom,jdbcType=VARCHAR},",
          "WYZNANIE_ID = #{wyznanieId,jdbcType=BIGINT},",
          "WYKSZTALCENIE_ID = #{wyksztalcenieId,jdbcType=BIGINT},",
          "DATA_ZGONU = #{dataZgonu,jdbcType=DATE}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(Osoba record);
}