package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.OsobaPracownik;
import pl.topteam.dps.model.main.OsobaPracownikCriteria;

public abstract interface OsobaPracownikMapper {
    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=OsobaPracownikSqlProvider.class, method="countByExample")
    int countByExample(OsobaPracownikCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @DeleteProvider(type=OsobaPracownikSqlProvider.class, method="deleteByExample")
    int deleteByExample(OsobaPracownikCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Delete({
        "delete from OSOBA_PRACOWNIK",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Insert({
        "insert into OSOBA_PRACOWNIK (OSOBA_ID, PRACOWNIK_ID, ",
        "PRACOWNIK_PRZYPISAL_ID, PRACOWNIK_ZMIENIL_ID, ",
        "DATA_PRZYPISANIA, DATA_ZMIANY, ",
        "TYP_PRACOWNIKA)",
        "values (#{osobaId,jdbcType=BIGINT}, #{pracownikId,jdbcType=BIGINT}, ",
        "#{pracownikPrzypisalId,jdbcType=BIGINT}, #{pracownikZmienilId,jdbcType=BIGINT}, ",
        "#{dataPrzypisania,jdbcType=TIMESTAMP}, #{dataZmiany,jdbcType=TIMESTAMP}, ",
        "#{typPracownika,jdbcType=VARCHAR})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(OsobaPracownik record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    int mergeInto(OsobaPracownik record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @InsertProvider(type=OsobaPracownikSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(OsobaPracownik record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=OsobaPracownikSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="PRACOWNIK_ID", property="pracownikId", jdbcType=JdbcType.BIGINT),
        @Result(column="PRACOWNIK_PRZYPISAL_ID", property="pracownikPrzypisalId", jdbcType=JdbcType.BIGINT),
        @Result(column="PRACOWNIK_ZMIENIL_ID", property="pracownikZmienilId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_PRZYPISANIA", property="dataPrzypisania", jdbcType=JdbcType.TIMESTAMP),
        @Result(column="DATA_ZMIANY", property="dataZmiany", jdbcType=JdbcType.TIMESTAMP),
        @Result(column="TYP_PRACOWNIKA", property="typPracownika", jdbcType=JdbcType.VARCHAR)
    })
    List<OsobaPracownik> selectByExampleWithRowbounds(OsobaPracownikCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=OsobaPracownikSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="PRACOWNIK_ID", property="pracownikId", jdbcType=JdbcType.BIGINT),
        @Result(column="PRACOWNIK_PRZYPISAL_ID", property="pracownikPrzypisalId", jdbcType=JdbcType.BIGINT),
        @Result(column="PRACOWNIK_ZMIENIL_ID", property="pracownikZmienilId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_PRZYPISANIA", property="dataPrzypisania", jdbcType=JdbcType.TIMESTAMP),
        @Result(column="DATA_ZMIANY", property="dataZmiany", jdbcType=JdbcType.TIMESTAMP),
        @Result(column="TYP_PRACOWNIKA", property="typPracownika", jdbcType=JdbcType.VARCHAR)
    })
    List<OsobaPracownik> selectByExample(OsobaPracownikCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Select({
        "select",
        "ID, OSOBA_ID, PRACOWNIK_ID, PRACOWNIK_PRZYPISAL_ID, PRACOWNIK_ZMIENIL_ID, DATA_PRZYPISANIA, ",
        "DATA_ZMIANY, TYP_PRACOWNIKA",
        "from OSOBA_PRACOWNIK",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="PRACOWNIK_ID", property="pracownikId", jdbcType=JdbcType.BIGINT),
        @Result(column="PRACOWNIK_PRZYPISAL_ID", property="pracownikPrzypisalId", jdbcType=JdbcType.BIGINT),
        @Result(column="PRACOWNIK_ZMIENIL_ID", property="pracownikZmienilId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_PRZYPISANIA", property="dataPrzypisania", jdbcType=JdbcType.TIMESTAMP),
        @Result(column="DATA_ZMIANY", property="dataZmiany", jdbcType=JdbcType.TIMESTAMP),
        @Result(column="TYP_PRACOWNIKA", property="typPracownika", jdbcType=JdbcType.VARCHAR)
    })
    OsobaPracownik selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=OsobaPracownikSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") OsobaPracownik record, @Param("example") OsobaPracownikCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=OsobaPracownikSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") OsobaPracownik record, @Param("example") OsobaPracownikCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=OsobaPracownikSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(OsobaPracownik record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Update({
        "update OSOBA_PRACOWNIK",
        "set OSOBA_ID = #{osobaId,jdbcType=BIGINT},",
          "PRACOWNIK_ID = #{pracownikId,jdbcType=BIGINT},",
          "PRACOWNIK_PRZYPISAL_ID = #{pracownikPrzypisalId,jdbcType=BIGINT},",
          "PRACOWNIK_ZMIENIL_ID = #{pracownikZmienilId,jdbcType=BIGINT},",
          "DATA_PRZYPISANIA = #{dataPrzypisania,jdbcType=TIMESTAMP},",
          "DATA_ZMIANY = #{dataZmiany,jdbcType=TIMESTAMP},",
          "TYP_PRACOWNIKA = #{typPracownika,jdbcType=VARCHAR}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(OsobaPracownik record);
}