package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.PobieraneSwiadczenie;
import pl.topteam.dps.model.main.PobieraneSwiadczenieCriteria;

public abstract interface PobieraneSwiadczenieMapper {
    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=PobieraneSwiadczenieSqlProvider.class, method="countByExample")
    int countByExample(PobieraneSwiadczenieCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @DeleteProvider(type=PobieraneSwiadczenieSqlProvider.class, method="deleteByExample")
    int deleteByExample(PobieraneSwiadczenieCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Delete({
        "delete from POBIERANE_SWIADCZENIE",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Insert({
        "insert into POBIERANE_SWIADCZENIE (OSOBA_ID, SWIADCZENIE_ZMIENIONE_ID, ",
        "DATA_OD, DATA_DO, DATA_ZMIANY, ",
        "KWOTA, NR, RODZAJ_ODBIORU, ",
        "INSTYTUCJA_DOPLACAJACA_ID, TERMIN_WYPLATY_ID, ",
        "KOD_SWIADCZENIA_ID)",
        "values (#{osobaId,jdbcType=BIGINT}, #{swiadczenieZmienioneId,jdbcType=BIGINT}, ",
        "#{dataOd,jdbcType=DATE}, #{dataDo,jdbcType=DATE}, #{dataZmiany,jdbcType=DATE}, ",
        "#{kwota,jdbcType=DECIMAL}, #{nr,jdbcType=VARCHAR}, #{rodzajOdbioru,jdbcType=VARCHAR}, ",
        "#{instytucjaDoplacajacaId,jdbcType=BIGINT}, #{terminWyplatyId,jdbcType=BIGINT}, ",
        "#{kodSwiadczeniaId,jdbcType=BIGINT})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(PobieraneSwiadczenie record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    int mergeInto(PobieraneSwiadczenie record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @InsertProvider(type=PobieraneSwiadczenieSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(PobieraneSwiadczenie record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=PobieraneSwiadczenieSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="SWIADCZENIE_ZMIENIONE_ID", property="swiadczenieZmienioneId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_OD", property="dataOd", jdbcType=JdbcType.DATE),
        @Result(column="DATA_DO", property="dataDo", jdbcType=JdbcType.DATE),
        @Result(column="DATA_ZMIANY", property="dataZmiany", jdbcType=JdbcType.DATE),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.DECIMAL),
        @Result(column="NR", property="nr", jdbcType=JdbcType.VARCHAR),
        @Result(column="RODZAJ_ODBIORU", property="rodzajOdbioru", jdbcType=JdbcType.VARCHAR),
        @Result(column="INSTYTUCJA_DOPLACAJACA_ID", property="instytucjaDoplacajacaId", jdbcType=JdbcType.BIGINT),
        @Result(column="TERMIN_WYPLATY_ID", property="terminWyplatyId", jdbcType=JdbcType.BIGINT),
        @Result(column="KOD_SWIADCZENIA_ID", property="kodSwiadczeniaId", jdbcType=JdbcType.BIGINT)
    })
    List<PobieraneSwiadczenie> selectByExampleWithRowbounds(PobieraneSwiadczenieCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=PobieraneSwiadczenieSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="SWIADCZENIE_ZMIENIONE_ID", property="swiadczenieZmienioneId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_OD", property="dataOd", jdbcType=JdbcType.DATE),
        @Result(column="DATA_DO", property="dataDo", jdbcType=JdbcType.DATE),
        @Result(column="DATA_ZMIANY", property="dataZmiany", jdbcType=JdbcType.DATE),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.DECIMAL),
        @Result(column="NR", property="nr", jdbcType=JdbcType.VARCHAR),
        @Result(column="RODZAJ_ODBIORU", property="rodzajOdbioru", jdbcType=JdbcType.VARCHAR),
        @Result(column="INSTYTUCJA_DOPLACAJACA_ID", property="instytucjaDoplacajacaId", jdbcType=JdbcType.BIGINT),
        @Result(column="TERMIN_WYPLATY_ID", property="terminWyplatyId", jdbcType=JdbcType.BIGINT),
        @Result(column="KOD_SWIADCZENIA_ID", property="kodSwiadczeniaId", jdbcType=JdbcType.BIGINT)
    })
    List<PobieraneSwiadczenie> selectByExample(PobieraneSwiadczenieCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Select({
        "select",
        "ID, OSOBA_ID, SWIADCZENIE_ZMIENIONE_ID, DATA_OD, DATA_DO, DATA_ZMIANY, KWOTA, ",
        "NR, RODZAJ_ODBIORU, INSTYTUCJA_DOPLACAJACA_ID, TERMIN_WYPLATY_ID, KOD_SWIADCZENIA_ID",
        "from POBIERANE_SWIADCZENIE",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="SWIADCZENIE_ZMIENIONE_ID", property="swiadczenieZmienioneId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_OD", property="dataOd", jdbcType=JdbcType.DATE),
        @Result(column="DATA_DO", property="dataDo", jdbcType=JdbcType.DATE),
        @Result(column="DATA_ZMIANY", property="dataZmiany", jdbcType=JdbcType.DATE),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.DECIMAL),
        @Result(column="NR", property="nr", jdbcType=JdbcType.VARCHAR),
        @Result(column="RODZAJ_ODBIORU", property="rodzajOdbioru", jdbcType=JdbcType.VARCHAR),
        @Result(column="INSTYTUCJA_DOPLACAJACA_ID", property="instytucjaDoplacajacaId", jdbcType=JdbcType.BIGINT),
        @Result(column="TERMIN_WYPLATY_ID", property="terminWyplatyId", jdbcType=JdbcType.BIGINT),
        @Result(column="KOD_SWIADCZENIA_ID", property="kodSwiadczeniaId", jdbcType=JdbcType.BIGINT)
    })
    PobieraneSwiadczenie selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=PobieraneSwiadczenieSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") PobieraneSwiadczenie record, @Param("example") PobieraneSwiadczenieCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=PobieraneSwiadczenieSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") PobieraneSwiadczenie record, @Param("example") PobieraneSwiadczenieCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=PobieraneSwiadczenieSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(PobieraneSwiadczenie record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Update({
        "update POBIERANE_SWIADCZENIE",
        "set OSOBA_ID = #{osobaId,jdbcType=BIGINT},",
          "SWIADCZENIE_ZMIENIONE_ID = #{swiadczenieZmienioneId,jdbcType=BIGINT},",
          "DATA_OD = #{dataOd,jdbcType=DATE},",
          "DATA_DO = #{dataDo,jdbcType=DATE},",
          "DATA_ZMIANY = #{dataZmiany,jdbcType=DATE},",
          "KWOTA = #{kwota,jdbcType=DECIMAL},",
          "NR = #{nr,jdbcType=VARCHAR},",
          "RODZAJ_ODBIORU = #{rodzajOdbioru,jdbcType=VARCHAR},",
          "INSTYTUCJA_DOPLACAJACA_ID = #{instytucjaDoplacajacaId,jdbcType=BIGINT},",
          "TERMIN_WYPLATY_ID = #{terminWyplatyId,jdbcType=BIGINT},",
          "KOD_SWIADCZENIA_ID = #{kodSwiadczeniaId,jdbcType=BIGINT}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(PobieraneSwiadczenie record);
}