package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.PolitykaBezpieczenstwa;
import pl.topteam.dps.model.main_gen.PolitykaBezpieczenstwaCriteria.Criteria;
import pl.topteam.dps.model.main_gen.PolitykaBezpieczenstwaCriteria.Criterion;
import pl.topteam.dps.model.main.PolitykaBezpieczenstwaCriteria;

public class PolitykaBezpieczenstwaSqlProvider {

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String countByExample(PolitykaBezpieczenstwaCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("POLITYKA_BEZPIECZENSTWA");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String deleteByExample(PolitykaBezpieczenstwaCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("POLITYKA_BEZPIECZENSTWA");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String insertSelective(PolitykaBezpieczenstwa record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("POLITYKA_BEZPIECZENSTWA");
        
        if (record.getDlHistoriiHasla() != null) {
            sql.VALUES("DL_HISTORII_HASLA", "#{dlHistoriiHasla,jdbcType=INTEGER}");
        }
        
        if (record.getMinDlHasla() != null) {
            sql.VALUES("MIN_DL_HASLA", "#{minDlHasla,jdbcType=INTEGER}");
        }
        
        if (record.getMaxDlHasla() != null) {
            sql.VALUES("MAX_DL_HASLA", "#{maxDlHasla,jdbcType=INTEGER}");
        }
        
        if (record.getProbNLogowan() != null) {
            sql.VALUES("PROB_N_LOGOWAN", "#{probNLogowan,jdbcType=INTEGER}");
        }
        
        if (record.getProbCzasBlokady() != null) {
            sql.VALUES("PROB_CZAS_BLOKADY", "#{probCzasBlokady,jdbcType=INTEGER}");
        }
        
        if (record.getlDniObowiazywaniaHasla() != null) {
            sql.VALUES("L_DNI_OBOWIAZYWANIA_HASLA", "#{lDniObowiazywaniaHasla,jdbcType=INTEGER}");
        }
        
        if (record.getlDniZmianaHasla() != null) {
            sql.VALUES("L_DNI_ZMIANA_HASLA", "#{lDniZmianaHasla,jdbcType=INTEGER}");
        }
        
        if (record.getZastosuj() != null) {
            sql.VALUES("ZASTOSUJ", "#{zastosuj,jdbcType=BOOLEAN}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String selectByExample(PolitykaBezpieczenstwaCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("DL_HISTORII_HASLA");
        sql.SELECT("MIN_DL_HASLA");
        sql.SELECT("MAX_DL_HASLA");
        sql.SELECT("PROB_N_LOGOWAN");
        sql.SELECT("PROB_CZAS_BLOKADY");
        sql.SELECT("L_DNI_OBOWIAZYWANIA_HASLA");
        sql.SELECT("L_DNI_ZMIANA_HASLA");
        sql.SELECT("ZASTOSUJ");
        sql.FROM("POLITYKA_BEZPIECZENSTWA");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        PolitykaBezpieczenstwa record = (PolitykaBezpieczenstwa) parameter.get("record");
        PolitykaBezpieczenstwaCriteria example = (PolitykaBezpieczenstwaCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("POLITYKA_BEZPIECZENSTWA");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getDlHistoriiHasla() != null) {
            sql.SET("DL_HISTORII_HASLA = #{record.dlHistoriiHasla,jdbcType=INTEGER}");
        }
        
        if (record.getMinDlHasla() != null) {
            sql.SET("MIN_DL_HASLA = #{record.minDlHasla,jdbcType=INTEGER}");
        }
        
        if (record.getMaxDlHasla() != null) {
            sql.SET("MAX_DL_HASLA = #{record.maxDlHasla,jdbcType=INTEGER}");
        }
        
        if (record.getProbNLogowan() != null) {
            sql.SET("PROB_N_LOGOWAN = #{record.probNLogowan,jdbcType=INTEGER}");
        }
        
        if (record.getProbCzasBlokady() != null) {
            sql.SET("PROB_CZAS_BLOKADY = #{record.probCzasBlokady,jdbcType=INTEGER}");
        }
        
        if (record.getlDniObowiazywaniaHasla() != null) {
            sql.SET("L_DNI_OBOWIAZYWANIA_HASLA = #{record.lDniObowiazywaniaHasla,jdbcType=INTEGER}");
        }
        
        if (record.getlDniZmianaHasla() != null) {
            sql.SET("L_DNI_ZMIANA_HASLA = #{record.lDniZmianaHasla,jdbcType=INTEGER}");
        }
        
        if (record.getZastosuj() != null) {
            sql.SET("ZASTOSUJ = #{record.zastosuj,jdbcType=BOOLEAN}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("POLITYKA_BEZPIECZENSTWA");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("DL_HISTORII_HASLA = #{record.dlHistoriiHasla,jdbcType=INTEGER}");
        sql.SET("MIN_DL_HASLA = #{record.minDlHasla,jdbcType=INTEGER}");
        sql.SET("MAX_DL_HASLA = #{record.maxDlHasla,jdbcType=INTEGER}");
        sql.SET("PROB_N_LOGOWAN = #{record.probNLogowan,jdbcType=INTEGER}");
        sql.SET("PROB_CZAS_BLOKADY = #{record.probCzasBlokady,jdbcType=INTEGER}");
        sql.SET("L_DNI_OBOWIAZYWANIA_HASLA = #{record.lDniObowiazywaniaHasla,jdbcType=INTEGER}");
        sql.SET("L_DNI_ZMIANA_HASLA = #{record.lDniZmianaHasla,jdbcType=INTEGER}");
        sql.SET("ZASTOSUJ = #{record.zastosuj,jdbcType=BOOLEAN}");
        
        PolitykaBezpieczenstwaCriteria example = (PolitykaBezpieczenstwaCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByPrimaryKeySelective(PolitykaBezpieczenstwa record) {
        SQL sql = new SQL();
        sql.UPDATE("POLITYKA_BEZPIECZENSTWA");
        
        if (record.getDlHistoriiHasla() != null) {
            sql.SET("DL_HISTORII_HASLA = #{dlHistoriiHasla,jdbcType=INTEGER}");
        }
        
        if (record.getMinDlHasla() != null) {
            sql.SET("MIN_DL_HASLA = #{minDlHasla,jdbcType=INTEGER}");
        }
        
        if (record.getMaxDlHasla() != null) {
            sql.SET("MAX_DL_HASLA = #{maxDlHasla,jdbcType=INTEGER}");
        }
        
        if (record.getProbNLogowan() != null) {
            sql.SET("PROB_N_LOGOWAN = #{probNLogowan,jdbcType=INTEGER}");
        }
        
        if (record.getProbCzasBlokady() != null) {
            sql.SET("PROB_CZAS_BLOKADY = #{probCzasBlokady,jdbcType=INTEGER}");
        }
        
        if (record.getlDniObowiazywaniaHasla() != null) {
            sql.SET("L_DNI_OBOWIAZYWANIA_HASLA = #{lDniObowiazywaniaHasla,jdbcType=INTEGER}");
        }
        
        if (record.getlDniZmianaHasla() != null) {
            sql.SET("L_DNI_ZMIANA_HASLA = #{lDniZmianaHasla,jdbcType=INTEGER}");
        }
        
        if (record.getZastosuj() != null) {
            sql.SET("ZASTOSUJ = #{zastosuj,jdbcType=BOOLEAN}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    protected void applyWhere(SQL sql, PolitykaBezpieczenstwaCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}