package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.RodzajPobSwiadczenia;
import pl.topteam.dps.model.main_gen.RodzajPobSwiadczeniaCriteria.Criteria;
import pl.topteam.dps.model.main_gen.RodzajPobSwiadczeniaCriteria.Criterion;
import pl.topteam.dps.model.main.RodzajPobSwiadczeniaCriteria;

public class RodzajPobSwiadczeniaSqlProvider {

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String countByExample(RodzajPobSwiadczeniaCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("RODZAJ_POB_SWIADCZENIA");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String deleteByExample(RodzajPobSwiadczeniaCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("RODZAJ_POB_SWIADCZENIA");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String insertSelective(RodzajPobSwiadczenia record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("RODZAJ_POB_SWIADCZENIA");
        
        if (record.getOdliczeniePobytDzienZgonu() != null) {
            sql.VALUES("ODLICZENIE_POBYT_DZIEN_ZGONU", "#{odliczeniePobytDzienZgonu,jdbcType=VARCHAR}");
        }
        
        if (record.getOdliczeniePobytPoZgon() != null) {
            sql.VALUES("ODLICZENIE_POBYT_PO_ZGON", "#{odliczeniePobytPoZgon,jdbcType=VARCHAR}");
        }
        
        if (record.getOdliczeniePobytPrzedZgon() != null) {
            sql.VALUES("ODLICZENIE_POBYT_PRZED_ZGON", "#{odliczeniePobytPrzedZgon,jdbcType=VARCHAR}");
        }
        
        if (record.getZwrotWyplataDzienZgonu() != null) {
            sql.VALUES("ZWROT_WYPLATA_DZIEN_ZGONU", "#{zwrotWyplataDzienZgonu,jdbcType=VARCHAR}");
        }
        
        if (record.getZwrotWyplataPoZgon() != null) {
            sql.VALUES("ZWROT_WYPLATA_PO_ZGON", "#{zwrotWyplataPoZgon,jdbcType=VARCHAR}");
        }
        
        if (record.getZwrotWyplataPrzedZgon() != null) {
            sql.VALUES("ZWROT_WYPLATA_PRZED_ZGON", "#{zwrotWyplataPrzedZgon,jdbcType=VARCHAR}");
        }
        
        if (record.getKod() != null) {
            sql.VALUES("KOD", "#{kod,jdbcType=VARCHAR}");
        }
        
        if (record.getTekst() != null) {
            sql.VALUES("TEKST", "#{tekst,jdbcType=VARCHAR}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String selectByExample(RodzajPobSwiadczeniaCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("ODLICZENIE_POBYT_DZIEN_ZGONU");
        sql.SELECT("ODLICZENIE_POBYT_PO_ZGON");
        sql.SELECT("ODLICZENIE_POBYT_PRZED_ZGON");
        sql.SELECT("ZWROT_WYPLATA_DZIEN_ZGONU");
        sql.SELECT("ZWROT_WYPLATA_PO_ZGON");
        sql.SELECT("ZWROT_WYPLATA_PRZED_ZGON");
        sql.SELECT("KOD");
        sql.SELECT("TEKST");
        sql.FROM("RODZAJ_POB_SWIADCZENIA");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        RodzajPobSwiadczenia record = (RodzajPobSwiadczenia) parameter.get("record");
        RodzajPobSwiadczeniaCriteria example = (RodzajPobSwiadczeniaCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("RODZAJ_POB_SWIADCZENIA");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getOdliczeniePobytDzienZgonu() != null) {
            sql.SET("ODLICZENIE_POBYT_DZIEN_ZGONU = #{record.odliczeniePobytDzienZgonu,jdbcType=VARCHAR}");
        }
        
        if (record.getOdliczeniePobytPoZgon() != null) {
            sql.SET("ODLICZENIE_POBYT_PO_ZGON = #{record.odliczeniePobytPoZgon,jdbcType=VARCHAR}");
        }
        
        if (record.getOdliczeniePobytPrzedZgon() != null) {
            sql.SET("ODLICZENIE_POBYT_PRZED_ZGON = #{record.odliczeniePobytPrzedZgon,jdbcType=VARCHAR}");
        }
        
        if (record.getZwrotWyplataDzienZgonu() != null) {
            sql.SET("ZWROT_WYPLATA_DZIEN_ZGONU = #{record.zwrotWyplataDzienZgonu,jdbcType=VARCHAR}");
        }
        
        if (record.getZwrotWyplataPoZgon() != null) {
            sql.SET("ZWROT_WYPLATA_PO_ZGON = #{record.zwrotWyplataPoZgon,jdbcType=VARCHAR}");
        }
        
        if (record.getZwrotWyplataPrzedZgon() != null) {
            sql.SET("ZWROT_WYPLATA_PRZED_ZGON = #{record.zwrotWyplataPrzedZgon,jdbcType=VARCHAR}");
        }
        
        if (record.getKod() != null) {
            sql.SET("KOD = #{record.kod,jdbcType=VARCHAR}");
        }
        
        if (record.getTekst() != null) {
            sql.SET("TEKST = #{record.tekst,jdbcType=VARCHAR}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("RODZAJ_POB_SWIADCZENIA");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("ODLICZENIE_POBYT_DZIEN_ZGONU = #{record.odliczeniePobytDzienZgonu,jdbcType=VARCHAR}");
        sql.SET("ODLICZENIE_POBYT_PO_ZGON = #{record.odliczeniePobytPoZgon,jdbcType=VARCHAR}");
        sql.SET("ODLICZENIE_POBYT_PRZED_ZGON = #{record.odliczeniePobytPrzedZgon,jdbcType=VARCHAR}");
        sql.SET("ZWROT_WYPLATA_DZIEN_ZGONU = #{record.zwrotWyplataDzienZgonu,jdbcType=VARCHAR}");
        sql.SET("ZWROT_WYPLATA_PO_ZGON = #{record.zwrotWyplataPoZgon,jdbcType=VARCHAR}");
        sql.SET("ZWROT_WYPLATA_PRZED_ZGON = #{record.zwrotWyplataPrzedZgon,jdbcType=VARCHAR}");
        sql.SET("KOD = #{record.kod,jdbcType=VARCHAR}");
        sql.SET("TEKST = #{record.tekst,jdbcType=VARCHAR}");
        
        RodzajPobSwiadczeniaCriteria example = (RodzajPobSwiadczeniaCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByPrimaryKeySelective(RodzajPobSwiadczenia record) {
        SQL sql = new SQL();
        sql.UPDATE("RODZAJ_POB_SWIADCZENIA");
        
        if (record.getOdliczeniePobytDzienZgonu() != null) {
            sql.SET("ODLICZENIE_POBYT_DZIEN_ZGONU = #{odliczeniePobytDzienZgonu,jdbcType=VARCHAR}");
        }
        
        if (record.getOdliczeniePobytPoZgon() != null) {
            sql.SET("ODLICZENIE_POBYT_PO_ZGON = #{odliczeniePobytPoZgon,jdbcType=VARCHAR}");
        }
        
        if (record.getOdliczeniePobytPrzedZgon() != null) {
            sql.SET("ODLICZENIE_POBYT_PRZED_ZGON = #{odliczeniePobytPrzedZgon,jdbcType=VARCHAR}");
        }
        
        if (record.getZwrotWyplataDzienZgonu() != null) {
            sql.SET("ZWROT_WYPLATA_DZIEN_ZGONU = #{zwrotWyplataDzienZgonu,jdbcType=VARCHAR}");
        }
        
        if (record.getZwrotWyplataPoZgon() != null) {
            sql.SET("ZWROT_WYPLATA_PO_ZGON = #{zwrotWyplataPoZgon,jdbcType=VARCHAR}");
        }
        
        if (record.getZwrotWyplataPrzedZgon() != null) {
            sql.SET("ZWROT_WYPLATA_PRZED_ZGON = #{zwrotWyplataPrzedZgon,jdbcType=VARCHAR}");
        }
        
        if (record.getKod() != null) {
            sql.SET("KOD = #{kod,jdbcType=VARCHAR}");
        }
        
        if (record.getTekst() != null) {
            sql.SET("TEKST = #{tekst,jdbcType=VARCHAR}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    protected void applyWhere(SQL sql, RodzajPobSwiadczeniaCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}