package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.Rozliczenie;
import pl.topteam.dps.model.main.RozliczenieCriteria;

public abstract interface RozliczenieMapper {
    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=RozliczenieSqlProvider.class, method="countByExample")
    int countByExample(RozliczenieCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @DeleteProvider(type=RozliczenieSqlProvider.class, method="deleteByExample")
    int deleteByExample(RozliczenieCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Delete({
        "delete from ROZLICZENIE",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Insert({
        "insert into ROZLICZENIE (MIESZKANIEC_ID, PRACOWNIK_WYKONAL_ID, ",
        "DATA, DATA_WYKONANIA)",
        "values (#{mieszkaniecId,jdbcType=BIGINT}, #{pracownikWykonalId,jdbcType=BIGINT}, ",
        "#{data,jdbcType=DATE}, #{dataWykonania,jdbcType=DATE})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(Rozliczenie record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    int mergeInto(Rozliczenie record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @InsertProvider(type=RozliczenieSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(Rozliczenie record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=RozliczenieSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="MIESZKANIEC_ID", property="mieszkaniecId", jdbcType=JdbcType.BIGINT),
        @Result(column="PRACOWNIK_WYKONAL_ID", property="pracownikWykonalId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA", property="data", jdbcType=JdbcType.DATE),
        @Result(column="DATA_WYKONANIA", property="dataWykonania", jdbcType=JdbcType.DATE)
    })
    List<Rozliczenie> selectByExampleWithRowbounds(RozliczenieCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=RozliczenieSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="MIESZKANIEC_ID", property="mieszkaniecId", jdbcType=JdbcType.BIGINT),
        @Result(column="PRACOWNIK_WYKONAL_ID", property="pracownikWykonalId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA", property="data", jdbcType=JdbcType.DATE),
        @Result(column="DATA_WYKONANIA", property="dataWykonania", jdbcType=JdbcType.DATE)
    })
    List<Rozliczenie> selectByExample(RozliczenieCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Select({
        "select",
        "ID, MIESZKANIEC_ID, PRACOWNIK_WYKONAL_ID, DATA, DATA_WYKONANIA",
        "from ROZLICZENIE",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="MIESZKANIEC_ID", property="mieszkaniecId", jdbcType=JdbcType.BIGINT),
        @Result(column="PRACOWNIK_WYKONAL_ID", property="pracownikWykonalId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA", property="data", jdbcType=JdbcType.DATE),
        @Result(column="DATA_WYKONANIA", property="dataWykonania", jdbcType=JdbcType.DATE)
    })
    Rozliczenie selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=RozliczenieSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") Rozliczenie record, @Param("example") RozliczenieCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=RozliczenieSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") Rozliczenie record, @Param("example") RozliczenieCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=RozliczenieSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(Rozliczenie record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Update({
        "update ROZLICZENIE",
        "set MIESZKANIEC_ID = #{mieszkaniecId,jdbcType=BIGINT},",
          "PRACOWNIK_WYKONAL_ID = #{pracownikWykonalId,jdbcType=BIGINT},",
          "DATA = #{data,jdbcType=DATE},",
          "DATA_WYKONANIA = #{dataWykonania,jdbcType=DATE}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(Rozliczenie record);
}