package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.Slowo;
import pl.topteam.dps.model.main.SlowoCriteria;

public abstract interface SlowoMapper {
    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=SlowoSqlProvider.class, method="countByExample")
    int countByExample(SlowoCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @DeleteProvider(type=SlowoSqlProvider.class, method="deleteByExample")
    int deleteByExample(SlowoCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Delete({
        "delete from SLOWO",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Insert({
        "insert into SLOWO (SLOWNIK_ID, KOD, ",
        "WART_STRING, WART_INT, ",
        "WAZNOSC_OD, WAZNOSC_DO, ",
        "KOLEJNOSC)",
        "values (#{slownikId,jdbcType=BIGINT}, #{kod,jdbcType=VARCHAR}, ",
        "#{wartString,jdbcType=VARCHAR}, #{wartInt,jdbcType=INTEGER}, ",
        "#{waznoscOd,jdbcType=DATE}, #{waznoscDo,jdbcType=DATE}, ",
        "#{kolejnosc,jdbcType=INTEGER})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(Slowo record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    int mergeInto(Slowo record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @InsertProvider(type=SlowoSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(Slowo record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=SlowoSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="SLOWNIK_ID", property="slownikId", jdbcType=JdbcType.BIGINT),
        @Result(column="KOD", property="kod", jdbcType=JdbcType.VARCHAR),
        @Result(column="WART_STRING", property="wartString", jdbcType=JdbcType.VARCHAR),
        @Result(column="WART_INT", property="wartInt", jdbcType=JdbcType.INTEGER),
        @Result(column="WAZNOSC_OD", property="waznoscOd", jdbcType=JdbcType.DATE),
        @Result(column="WAZNOSC_DO", property="waznoscDo", jdbcType=JdbcType.DATE),
        @Result(column="KOLEJNOSC", property="kolejnosc", jdbcType=JdbcType.INTEGER)
    })
    List<Slowo> selectByExampleWithRowbounds(SlowoCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=SlowoSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="SLOWNIK_ID", property="slownikId", jdbcType=JdbcType.BIGINT),
        @Result(column="KOD", property="kod", jdbcType=JdbcType.VARCHAR),
        @Result(column="WART_STRING", property="wartString", jdbcType=JdbcType.VARCHAR),
        @Result(column="WART_INT", property="wartInt", jdbcType=JdbcType.INTEGER),
        @Result(column="WAZNOSC_OD", property="waznoscOd", jdbcType=JdbcType.DATE),
        @Result(column="WAZNOSC_DO", property="waznoscDo", jdbcType=JdbcType.DATE),
        @Result(column="KOLEJNOSC", property="kolejnosc", jdbcType=JdbcType.INTEGER)
    })
    List<Slowo> selectByExample(SlowoCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Select({
        "select",
        "ID, SLOWNIK_ID, KOD, WART_STRING, WART_INT, WAZNOSC_OD, WAZNOSC_DO, KOLEJNOSC",
        "from SLOWO",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="SLOWNIK_ID", property="slownikId", jdbcType=JdbcType.BIGINT),
        @Result(column="KOD", property="kod", jdbcType=JdbcType.VARCHAR),
        @Result(column="WART_STRING", property="wartString", jdbcType=JdbcType.VARCHAR),
        @Result(column="WART_INT", property="wartInt", jdbcType=JdbcType.INTEGER),
        @Result(column="WAZNOSC_OD", property="waznoscOd", jdbcType=JdbcType.DATE),
        @Result(column="WAZNOSC_DO", property="waznoscDo", jdbcType=JdbcType.DATE),
        @Result(column="KOLEJNOSC", property="kolejnosc", jdbcType=JdbcType.INTEGER)
    })
    Slowo selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=SlowoSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") Slowo record, @Param("example") SlowoCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=SlowoSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") Slowo record, @Param("example") SlowoCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=SlowoSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(Slowo record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Update({
        "update SLOWO",
        "set SLOWNIK_ID = #{slownikId,jdbcType=BIGINT},",
          "KOD = #{kod,jdbcType=VARCHAR},",
          "WART_STRING = #{wartString,jdbcType=VARCHAR},",
          "WART_INT = #{wartInt,jdbcType=INTEGER},",
          "WAZNOSC_OD = #{waznoscOd,jdbcType=DATE},",
          "WAZNOSC_DO = #{waznoscDo,jdbcType=DATE},",
          "KOLEJNOSC = #{kolejnosc,jdbcType=INTEGER}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(Slowo record);
}