package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.ZadluzenieWyrownanie;
import pl.topteam.dps.model.main_gen.ZadluzenieWyrownanieCriteria.Criteria;
import pl.topteam.dps.model.main_gen.ZadluzenieWyrownanieCriteria.Criterion;
import pl.topteam.dps.model.main.ZadluzenieWyrownanieCriteria;

public class ZadluzenieWyrownanieSqlProvider {

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String countByExample(ZadluzenieWyrownanieCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("ZADLUZENIE_WYROWNANIE");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String deleteByExample(ZadluzenieWyrownanieCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("ZADLUZENIE_WYROWNANIE");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String insertSelective(ZadluzenieWyrownanie record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("ZADLUZENIE_WYROWNANIE");
        
        if (record.getFakturaId() != null) {
            sql.VALUES("FAKTURA_ID", "#{fakturaId,jdbcType=BIGINT}");
        }
        
        if (record.getNotaPozycjaId() != null) {
            sql.VALUES("NOTA_POZYCJA_ID", "#{notaPozycjaId,jdbcType=BIGINT}");
        }
        
        if (record.getOdpisId() != null) {
            sql.VALUES("ODPIS_ID", "#{odpisId,jdbcType=BIGINT}");
        }
        
        if (record.getZadluzeniePozycjaId() != null) {
            sql.VALUES("ZADLUZENIE_POZYCJA_ID", "#{zadluzeniePozycjaId,jdbcType=BIGINT}");
        }
        
        if (record.getZwrotId() != null) {
            sql.VALUES("ZWROT_ID", "#{zwrotId,jdbcType=BIGINT}");
        }
        
        if (record.getKwota() != null) {
            sql.VALUES("KWOTA", "#{kwota,jdbcType=DECIMAL}");
        }
        
        if (record.getStatus() != null) {
            sql.VALUES("STATUS", "#{status,jdbcType=VARCHAR}");
        }
        
        if (record.getKwotaOdpisu() != null) {
            sql.VALUES("KWOTA_ODPISU", "#{kwotaOdpisu,jdbcType=DECIMAL}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String selectByExample(ZadluzenieWyrownanieCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("FAKTURA_ID");
        sql.SELECT("NOTA_POZYCJA_ID");
        sql.SELECT("ODPIS_ID");
        sql.SELECT("ZADLUZENIE_POZYCJA_ID");
        sql.SELECT("ZWROT_ID");
        sql.SELECT("KWOTA");
        sql.SELECT("STATUS");
        sql.SELECT("KWOTA_ODPISU");
        sql.FROM("ZADLUZENIE_WYROWNANIE");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        ZadluzenieWyrownanie record = (ZadluzenieWyrownanie) parameter.get("record");
        ZadluzenieWyrownanieCriteria example = (ZadluzenieWyrownanieCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("ZADLUZENIE_WYROWNANIE");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getFakturaId() != null) {
            sql.SET("FAKTURA_ID = #{record.fakturaId,jdbcType=BIGINT}");
        }
        
        if (record.getNotaPozycjaId() != null) {
            sql.SET("NOTA_POZYCJA_ID = #{record.notaPozycjaId,jdbcType=BIGINT}");
        }
        
        if (record.getOdpisId() != null) {
            sql.SET("ODPIS_ID = #{record.odpisId,jdbcType=BIGINT}");
        }
        
        if (record.getZadluzeniePozycjaId() != null) {
            sql.SET("ZADLUZENIE_POZYCJA_ID = #{record.zadluzeniePozycjaId,jdbcType=BIGINT}");
        }
        
        if (record.getZwrotId() != null) {
            sql.SET("ZWROT_ID = #{record.zwrotId,jdbcType=BIGINT}");
        }
        
        if (record.getKwota() != null) {
            sql.SET("KWOTA = #{record.kwota,jdbcType=DECIMAL}");
        }
        
        if (record.getStatus() != null) {
            sql.SET("STATUS = #{record.status,jdbcType=VARCHAR}");
        }
        
        if (record.getKwotaOdpisu() != null) {
            sql.SET("KWOTA_ODPISU = #{record.kwotaOdpisu,jdbcType=DECIMAL}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("ZADLUZENIE_WYROWNANIE");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("FAKTURA_ID = #{record.fakturaId,jdbcType=BIGINT}");
        sql.SET("NOTA_POZYCJA_ID = #{record.notaPozycjaId,jdbcType=BIGINT}");
        sql.SET("ODPIS_ID = #{record.odpisId,jdbcType=BIGINT}");
        sql.SET("ZADLUZENIE_POZYCJA_ID = #{record.zadluzeniePozycjaId,jdbcType=BIGINT}");
        sql.SET("ZWROT_ID = #{record.zwrotId,jdbcType=BIGINT}");
        sql.SET("KWOTA = #{record.kwota,jdbcType=DECIMAL}");
        sql.SET("STATUS = #{record.status,jdbcType=VARCHAR}");
        sql.SET("KWOTA_ODPISU = #{record.kwotaOdpisu,jdbcType=DECIMAL}");
        
        ZadluzenieWyrownanieCriteria example = (ZadluzenieWyrownanieCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByPrimaryKeySelective(ZadluzenieWyrownanie record) {
        SQL sql = new SQL();
        sql.UPDATE("ZADLUZENIE_WYROWNANIE");
        
        if (record.getFakturaId() != null) {
            sql.SET("FAKTURA_ID = #{fakturaId,jdbcType=BIGINT}");
        }
        
        if (record.getNotaPozycjaId() != null) {
            sql.SET("NOTA_POZYCJA_ID = #{notaPozycjaId,jdbcType=BIGINT}");
        }
        
        if (record.getOdpisId() != null) {
            sql.SET("ODPIS_ID = #{odpisId,jdbcType=BIGINT}");
        }
        
        if (record.getZadluzeniePozycjaId() != null) {
            sql.SET("ZADLUZENIE_POZYCJA_ID = #{zadluzeniePozycjaId,jdbcType=BIGINT}");
        }
        
        if (record.getZwrotId() != null) {
            sql.SET("ZWROT_ID = #{zwrotId,jdbcType=BIGINT}");
        }
        
        if (record.getKwota() != null) {
            sql.SET("KWOTA = #{kwota,jdbcType=DECIMAL}");
        }
        
        if (record.getStatus() != null) {
            sql.SET("STATUS = #{status,jdbcType=VARCHAR}");
        }
        
        if (record.getKwotaOdpisu() != null) {
            sql.SET("KWOTA_ODPISU = #{kwotaOdpisu,jdbcType=DECIMAL}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    protected void applyWhere(SQL sql, ZadluzenieWyrownanieCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}