package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.ZlecenieSoczewka;
import pl.topteam.dps.model.main.ZlecenieSoczewkaCriteria;

public abstract interface ZlecenieSoczewkaMapper {
    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=ZlecenieSoczewkaSqlProvider.class, method="countByExample")
    int countByExample(ZlecenieSoczewkaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @DeleteProvider(type=ZlecenieSoczewkaSqlProvider.class, method="deleteByExample")
    int deleteByExample(ZlecenieSoczewkaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Delete({
        "delete from ZLECENIE_SOCZEWKA",
        "where ZLECENIE_ID = #{zlecenieId,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long zlecenieId);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Insert({
        "insert into ZLECENIE_SOCZEWKA (ZLECENIE_ID, RODZAJ, ",
        "OL_SFERA, OL_CYLINDER, ",
        "OL_OS, OL_PRYZMA, ",
        "OP_SFERA, OP_CYLINDER, ",
        "OP_OS, OP_PRYZMA, ",
        "ODL_ZRENIC)",
        "values (#{zlecenieId,jdbcType=BIGINT}, #{rodzaj,jdbcType=VARCHAR}, ",
        "#{olSfera,jdbcType=DECIMAL}, #{olCylinder,jdbcType=DECIMAL}, ",
        "#{olOs,jdbcType=DECIMAL}, #{olPryzma,jdbcType=DECIMAL}, ",
        "#{opSfera,jdbcType=DECIMAL}, #{opCylinder,jdbcType=DECIMAL}, ",
        "#{opOs,jdbcType=DECIMAL}, #{opPryzma,jdbcType=DECIMAL}, ",
        "#{odlZrenic,jdbcType=INTEGER})"
    })
    int insert(ZlecenieSoczewka record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    int mergeInto(ZlecenieSoczewka record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @InsertProvider(type=ZlecenieSoczewkaSqlProvider.class, method="insertSelective")
    int insertSelective(ZlecenieSoczewka record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=ZlecenieSoczewkaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ZLECENIE_ID", property="zlecenieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="RODZAJ", property="rodzaj", jdbcType=JdbcType.VARCHAR),
        @Result(column="OL_SFERA", property="olSfera", jdbcType=JdbcType.DECIMAL),
        @Result(column="OL_CYLINDER", property="olCylinder", jdbcType=JdbcType.DECIMAL),
        @Result(column="OL_OS", property="olOs", jdbcType=JdbcType.DECIMAL),
        @Result(column="OL_PRYZMA", property="olPryzma", jdbcType=JdbcType.DECIMAL),
        @Result(column="OP_SFERA", property="opSfera", jdbcType=JdbcType.DECIMAL),
        @Result(column="OP_CYLINDER", property="opCylinder", jdbcType=JdbcType.DECIMAL),
        @Result(column="OP_OS", property="opOs", jdbcType=JdbcType.DECIMAL),
        @Result(column="OP_PRYZMA", property="opPryzma", jdbcType=JdbcType.DECIMAL),
        @Result(column="ODL_ZRENIC", property="odlZrenic", jdbcType=JdbcType.INTEGER)
    })
    List<ZlecenieSoczewka> selectByExampleWithRowbounds(ZlecenieSoczewkaCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @SelectProvider(type=ZlecenieSoczewkaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ZLECENIE_ID", property="zlecenieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="RODZAJ", property="rodzaj", jdbcType=JdbcType.VARCHAR),
        @Result(column="OL_SFERA", property="olSfera", jdbcType=JdbcType.DECIMAL),
        @Result(column="OL_CYLINDER", property="olCylinder", jdbcType=JdbcType.DECIMAL),
        @Result(column="OL_OS", property="olOs", jdbcType=JdbcType.DECIMAL),
        @Result(column="OL_PRYZMA", property="olPryzma", jdbcType=JdbcType.DECIMAL),
        @Result(column="OP_SFERA", property="opSfera", jdbcType=JdbcType.DECIMAL),
        @Result(column="OP_CYLINDER", property="opCylinder", jdbcType=JdbcType.DECIMAL),
        @Result(column="OP_OS", property="opOs", jdbcType=JdbcType.DECIMAL),
        @Result(column="OP_PRYZMA", property="opPryzma", jdbcType=JdbcType.DECIMAL),
        @Result(column="ODL_ZRENIC", property="odlZrenic", jdbcType=JdbcType.INTEGER)
    })
    List<ZlecenieSoczewka> selectByExample(ZlecenieSoczewkaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Select({
        "select",
        "ZLECENIE_ID, RODZAJ, OL_SFERA, OL_CYLINDER, OL_OS, OL_PRYZMA, OP_SFERA, OP_CYLINDER, ",
        "OP_OS, OP_PRYZMA, ODL_ZRENIC",
        "from ZLECENIE_SOCZEWKA",
        "where ZLECENIE_ID = #{zlecenieId,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ZLECENIE_ID", property="zlecenieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="RODZAJ", property="rodzaj", jdbcType=JdbcType.VARCHAR),
        @Result(column="OL_SFERA", property="olSfera", jdbcType=JdbcType.DECIMAL),
        @Result(column="OL_CYLINDER", property="olCylinder", jdbcType=JdbcType.DECIMAL),
        @Result(column="OL_OS", property="olOs", jdbcType=JdbcType.DECIMAL),
        @Result(column="OL_PRYZMA", property="olPryzma", jdbcType=JdbcType.DECIMAL),
        @Result(column="OP_SFERA", property="opSfera", jdbcType=JdbcType.DECIMAL),
        @Result(column="OP_CYLINDER", property="opCylinder", jdbcType=JdbcType.DECIMAL),
        @Result(column="OP_OS", property="opOs", jdbcType=JdbcType.DECIMAL),
        @Result(column="OP_PRYZMA", property="opPryzma", jdbcType=JdbcType.DECIMAL),
        @Result(column="ODL_ZRENIC", property="odlZrenic", jdbcType=JdbcType.INTEGER)
    })
    ZlecenieSoczewka selectByPrimaryKey(Long zlecenieId);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=ZlecenieSoczewkaSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") ZlecenieSoczewka record, @Param("example") ZlecenieSoczewkaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=ZlecenieSoczewkaSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") ZlecenieSoczewka record, @Param("example") ZlecenieSoczewkaCriteria example);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @UpdateProvider(type=ZlecenieSoczewkaSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(ZlecenieSoczewka record);

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    @Update({
        "update ZLECENIE_SOCZEWKA",
        "set RODZAJ = #{rodzaj,jdbcType=VARCHAR},",
          "OL_SFERA = #{olSfera,jdbcType=DECIMAL},",
          "OL_CYLINDER = #{olCylinder,jdbcType=DECIMAL},",
          "OL_OS = #{olOs,jdbcType=DECIMAL},",
          "OL_PRYZMA = #{olPryzma,jdbcType=DECIMAL},",
          "OP_SFERA = #{opSfera,jdbcType=DECIMAL},",
          "OP_CYLINDER = #{opCylinder,jdbcType=DECIMAL},",
          "OP_OS = #{opOs,jdbcType=DECIMAL},",
          "OP_PRYZMA = #{opPryzma,jdbcType=DECIMAL},",
          "ODL_ZRENIC = #{odlZrenic,jdbcType=INTEGER}",
        "where ZLECENIE_ID = #{zlecenieId,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(ZlecenieSoczewka record);
}