package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.ZlecenieWydanieWyrob;
import pl.topteam.dps.model.main_gen.ZlecenieWydanieWyrobCriteria.Criteria;
import pl.topteam.dps.model.main_gen.ZlecenieWydanieWyrobCriteria.Criterion;
import pl.topteam.dps.model.main.ZlecenieWydanieWyrobCriteria;

public class ZlecenieWydanieWyrobSqlProvider {

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String countByExample(ZlecenieWydanieWyrobCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("ZLECENIE_WYDANIE_WYROB");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String deleteByExample(ZlecenieWydanieWyrobCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("ZLECENIE_WYDANIE_WYROB");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String insertSelective(ZlecenieWydanieWyrob record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("ZLECENIE_WYDANIE_WYROB");
        
        if (record.getZlecenieId() != null) {
            sql.VALUES("ZLECENIE_ID", "#{zlecenieId,jdbcType=BIGINT}");
        }
        
        if (record.getDaneWm() != null) {
            sql.VALUES("DANE_WM", "#{daneWm,jdbcType=VARCHAR}");
        }
        
        if (record.getDataOdbioru() != null) {
            sql.VALUES("DATA_ODBIORU", "#{dataOdbioru,jdbcType=DATE}");
        }
        
        if (record.getKwotaNfz() != null) {
            sql.VALUES("KWOTA_NFZ", "#{kwotaNfz,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaSwiadczeniobiorca() != null) {
            sql.VALUES("KWOTA_SWIADCZENIOBIORCA", "#{kwotaSwiadczeniobiorca,jdbcType=DECIMAL}");
        }
        
        if (record.getNrUmowy() != null) {
            sql.VALUES("NR_UMOWY", "#{nrUmowy,jdbcType=VARCHAR}");
        }
        
        if (record.getLiczbaSztuk() != null) {
            sql.VALUES("LICZBA_SZTUK", "#{liczbaSztuk,jdbcType=INTEGER}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String selectByExample(ZlecenieWydanieWyrobCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ZLECENIE_ID");
        } else {
            sql.SELECT("ZLECENIE_ID");
        }
        sql.SELECT("DANE_WM");
        sql.SELECT("DATA_ODBIORU");
        sql.SELECT("KWOTA_NFZ");
        sql.SELECT("KWOTA_SWIADCZENIOBIORCA");
        sql.SELECT("NR_UMOWY");
        sql.SELECT("LICZBA_SZTUK");
        sql.FROM("ZLECENIE_WYDANIE_WYROB");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        ZlecenieWydanieWyrob record = (ZlecenieWydanieWyrob) parameter.get("record");
        ZlecenieWydanieWyrobCriteria example = (ZlecenieWydanieWyrobCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("ZLECENIE_WYDANIE_WYROB");
        
        if (record.getZlecenieId() != null) {
            sql.SET("ZLECENIE_ID = #{record.zlecenieId,jdbcType=BIGINT}");
        }
        
        if (record.getDaneWm() != null) {
            sql.SET("DANE_WM = #{record.daneWm,jdbcType=VARCHAR}");
        }
        
        if (record.getDataOdbioru() != null) {
            sql.SET("DATA_ODBIORU = #{record.dataOdbioru,jdbcType=DATE}");
        }
        
        if (record.getKwotaNfz() != null) {
            sql.SET("KWOTA_NFZ = #{record.kwotaNfz,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaSwiadczeniobiorca() != null) {
            sql.SET("KWOTA_SWIADCZENIOBIORCA = #{record.kwotaSwiadczeniobiorca,jdbcType=DECIMAL}");
        }
        
        if (record.getNrUmowy() != null) {
            sql.SET("NR_UMOWY = #{record.nrUmowy,jdbcType=VARCHAR}");
        }
        
        if (record.getLiczbaSztuk() != null) {
            sql.SET("LICZBA_SZTUK = #{record.liczbaSztuk,jdbcType=INTEGER}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("ZLECENIE_WYDANIE_WYROB");
        
        sql.SET("ZLECENIE_ID = #{record.zlecenieId,jdbcType=BIGINT}");
        sql.SET("DANE_WM = #{record.daneWm,jdbcType=VARCHAR}");
        sql.SET("DATA_ODBIORU = #{record.dataOdbioru,jdbcType=DATE}");
        sql.SET("KWOTA_NFZ = #{record.kwotaNfz,jdbcType=DECIMAL}");
        sql.SET("KWOTA_SWIADCZENIOBIORCA = #{record.kwotaSwiadczeniobiorca,jdbcType=DECIMAL}");
        sql.SET("NR_UMOWY = #{record.nrUmowy,jdbcType=VARCHAR}");
        sql.SET("LICZBA_SZTUK = #{record.liczbaSztuk,jdbcType=INTEGER}");
        
        ZlecenieWydanieWyrobCriteria example = (ZlecenieWydanieWyrobCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    public String updateByPrimaryKeySelective(ZlecenieWydanieWyrob record) {
        SQL sql = new SQL();
        sql.UPDATE("ZLECENIE_WYDANIE_WYROB");
        
        if (record.getDaneWm() != null) {
            sql.SET("DANE_WM = #{daneWm,jdbcType=VARCHAR}");
        }
        
        if (record.getDataOdbioru() != null) {
            sql.SET("DATA_ODBIORU = #{dataOdbioru,jdbcType=DATE}");
        }
        
        if (record.getKwotaNfz() != null) {
            sql.SET("KWOTA_NFZ = #{kwotaNfz,jdbcType=DECIMAL}");
        }
        
        if (record.getKwotaSwiadczeniobiorca() != null) {
            sql.SET("KWOTA_SWIADCZENIOBIORCA = #{kwotaSwiadczeniobiorca,jdbcType=DECIMAL}");
        }
        
        if (record.getNrUmowy() != null) {
            sql.SET("NR_UMOWY = #{nrUmowy,jdbcType=VARCHAR}");
        }
        
        if (record.getLiczbaSztuk() != null) {
            sql.SET("LICZBA_SZTUK = #{liczbaSztuk,jdbcType=INTEGER}");
        }
        
        sql.WHERE("ZLECENIE_ID = #{zlecenieId,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-10 10:45:37
     */
    protected void applyWhere(SQL sql, ZlecenieWydanieWyrobCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}