package pl.topteam.dps.enums;

import pl.topteam.dps.enums.interfaces.EnumOpis;

public enum RodzajPlatnika implements EnumOpis {
	/** Każda osoba zobowiązana do płatności (włącznie z mieszkańcami) */
	OSOBA("osoba"),
	/** Mieszkaniec zobowiązany do płatności za swój pobyt */
	MIESZKANIEC("mieszkaniec"),
	/** Instytucja zobowiązana do płatności */
	INSTYTUCJA("instytucja")
	;

	private String opis;

	private RodzajPlatnika(String opis) {
		this.opis = opis;
	}

	@Override
	public String getOpis() {
		return this.opis;
	}
}