package pl.topteam.dps.enums;

import pl.topteam.dps.enums.interfaces.EnumOpis;

public enum RodzajZadluzenia implements EnumOpis {
	/** Pobyt mieszkańca */
	POBYT(true, "pobyt"),
	/** Leki dla mieszkańca */
	FAKTURY(true, "faktury"),
	/** Całość zadłużenia */
	CALOSC(false, "całość")
	;

	// czy brać pod uwagę przy automatycznym rozpatrywaniu m.in. wpłat
	private boolean autoRozliczane;
	private String opis;

	private RodzajZadluzenia(boolean autoRozliczane, String opis) {
		this.autoRozliczane = autoRozliczane;
		this.opis = opis;
	}

	public boolean isAutoRozliczane() {
		return autoRozliczane;
	}

	@Override
	public String getOpis() {
		return this.opis;
	}
}
