package pl.topteam.dps.enums;

import pl.topteam.dps.enums.interfaces.EnumOpis;

public enum UprawnienieLeki implements EnumOpis {
	X(Boolean.FALSE, "brak uprawnień"),
	AZ(Boolean.FALSE, "Chory na azbestozę"),
	IW(Boolean.FALSE, "Inwalida wojenny i rodzina, Osoba represjonowana i rodzina, Cywilna niewidoma ofiara działań wojennych"),
	IB(Boolean.FALSE, "Inwalida wojskowy i rodzina"),
	PO(Boolean.FALSE, "Pełniący obowiązki obronne"),
	ZK(Boolean.FALSE, "Zasłużony Honorowy Dawca Krwi, Zasłużony Dawca Przeszczepu"),
	DN(Boolean.FALSE, "dzieci do 18. roku życia, których rodzice są nieubezpieczeni"),
	IN(Boolean.FALSE, "osoba niebędąca ubezpieczonym, mająca uprawnienia do bezpłatnych świadczeń opieki zdrowotnej na podstawie przepisów innych ustaw, o której mowa w art. 12 ustawy"),

	UZ(Boolean.TRUE, "Ubezpieczony"),
	CHP(Boolean.TRUE, "Chory przewlekle"),
	CHPEB(Boolean.TRUE, "Chory przewlekle (Epidermolysis bullosa)"),
	CHPPO(Boolean.TRUE, "Chory przewlekle (Przewlekłe owrzodzenia)"),
	;

	private String opis;
	// ukryty przed możliwością wyboru
	private Boolean ukryty;

	private UprawnienieLeki(Boolean ukryty, String opis) {
		this.ukryty = ukryty;
		this.opis = opis;
	}

	public String getName() {
		return this.name();
	}

	public Boolean getUkryty() {
		return this.ukryty;
	}

	@Override
	public String getOpis() {
		return this.opis;
	}
}
