package pl.topteam.dps.generic;

import java.io.Serializable;

import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydrukuPominPole;

public abstract class GenericDPSObject implements Serializable {
	private static final long serialVersionUID = -3341381207529654417L;

	@ZmiennaWydrukuPominPole
	public Long getId() {
		throw new UnsupportedOperationException();
	}

	/**
	 * Metoda znacząco upraszcza stosowanie dynamicznych walidacji obiektów
	 * przedstawianych na formatkach. Zazwyczaj dla każdego takiego obiektu jest
	 * lista pól, które są wymagane.
	 *
	 * Należy przyjmować, że jeżeli takie wymagane pole nie jest puste to
	 * obiekt nie jest 'pusty' i tym samym podlega np. walidacji danych albo
	 * powinien być przedstawiany do zapisu.
	 *
	 * @return
	 */
	public boolean empty() {
		return getId() == null || getId() == 0L;
	}
}
