package pl.topteam.dps.model.extension;

import java.io.Serializable;

import net.karneim.pojobuilder.GeneratePojoBuilder;
import pl.topteam.dps.enums.GrupaUprawnien;
import pl.topteam.dps.enums.TypUprawnieniaKatUslug;

@GeneratePojoBuilder
public class UprawnienieCzynnoscKatUslug implements Serializable {
	private static final long serialVersionUID = -6159746781670225425L;

	private static GrupaUprawnien GRUPA_UPRAWNIEN_REALIZACJA_KAT_USL = GrupaUprawnien.MODUL_OGOLNY;
	private static String CZYNNOSC_PRZEDROSTEK = "_CZYNN_";

	private Long czynnoscId;
	private TypUprawnieniaKatUslug typUprawnienia;

	// przykładowe uprawnienie ma wygląd: OG_R_CZYNN_1
	public String getValue() {
		return GRUPA_UPRAWNIEN_REALIZACJA_KAT_USL.getPrzedrostek() +
				typUprawnienia.name() + CZYNNOSC_PRZEDROSTEK + czynnoscId;
	}

	public TypUprawnieniaKatUslug getTypUprawnienia() {
		return typUprawnienia;
	}

	public void setTypUprawnienia(TypUprawnieniaKatUslug typUprawnienia) {
		this.typUprawnienia = typUprawnienia;
	}

	public Long getCzynnoscId() {
		return czynnoscId;
	}

	public void setCzynnoscId(Long czynnoscId) {
		this.czynnoscId = czynnoscId;
	}
}
