package pl.topteam.dps.model.main;

import net.karneim.pojobuilder.GeneratePojoBuilder;

import org.joda.time.LocalDate;

import pl.topteam.utils.dateTime.DateUtils;

@GeneratePojoBuilder
public class OcenaOsoby extends pl.topteam.dps.model.main_gen.OcenaOsoby {
	private static final long serialVersionUID = -6159746781670225425L;

	private SkalaOcenyOsoby skalaOcenyOsoby;

	/**
	 * Pole głównie wykorzystywane w select
	 * @return
	 */
	public String getOpis() {
		if(getData() != null) {
			return "Ocena z dnia "
					+ DateUtils.DATE_FORMATTER.print(LocalDate.fromDateFields(getData()));
		}

		return "Ocena " + getId();
	}

	public SkalaOcenyOsoby getSkalaOcenyOsoby() {
		return skalaOcenyOsoby;
	}

	public void setSkalaOcenyOsoby(SkalaOcenyOsoby skalaOcenyOsoby) {
		this.skalaOcenyOsoby = skalaOcenyOsoby;
	}
}