package pl.topteam.dps.model.main;

import net.karneim.pojobuilder.GeneratePojoBuilder;

import org.joda.time.LocalDate;

import pl.topteam.utils.dateTime.DateUtils;

@GeneratePojoBuilder
public class SwiadczenieRealizacja extends pl.topteam.dps.model.main_gen.SwiadczenieRealizacja {

	/**
	 *
	 */
	private static final long serialVersionUID = -6159746781670225425L;

	private Swiadczenie swiadczenie;
	private Osoba mieszkaniec;

	public Osoba getMieszkaniec() {
		return mieszkaniec;
	}

	public void setMieszkaniec(Osoba mieszkaniec) {
		this.mieszkaniec = mieszkaniec;
	}

	public Swiadczenie getSwiadczenie() {
		return swiadczenie;
	}

	public void setSwiadczenie(Swiadczenie swiadczenie) {
		this.swiadczenie = swiadczenie;
	}

	public String getDataString() {
		if(getData()!=null) {
			return DateUtils.DATE_FORMATTER.print(LocalDate.fromDateFields(getData()));
		}
		return "";
	}

	public String getDataNrDnia() {
		if(getData() != null) {
			return ""+LocalDate.fromDateFields(getData()).getDayOfMonth();
		}

		return "";
	}
}