package pl.topteam.utils.wydruki.zmienne.model.wrapper;

import java.io.Serializable;

import org.apache.commons.lang3.builder.ToStringBuilder;

import pl.topteam.utils.wydruki.zmienne.enums.UzycieZmiennej;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydruku;

public class ZmiennaWydrukuWrapper implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = -6159746781670225425L;

	private ZmiennaWydruku zmiennaWydruku;
	
	public ZmiennaWydrukuWrapper(ZmiennaWydruku zmiennaWydruku) {
		this.zmiennaWydruku = zmiennaWydruku;
	}
	
	public String getNazwa() {
		return zmiennaWydruku.nazwa();
	}
	
	public String getId() {
		return zmiennaWydruku.id();
	}
	
	public UzycieZmiennej getMiejsceUzycia() {
		return zmiennaWydruku.miejsceUzycia();
	}
	
	public String getOpis() {
		return zmiennaWydruku.opis();
	}
	
	@Override
	public String toString() {
		if(zmiennaWydruku != null) {
			return new ToStringBuilder(zmiennaWydruku)
				.append("id", zmiennaWydruku.id())
				.append("nazwa", zmiennaWydruku.nazwa())
				.append("opis", zmiennaWydruku.miejsceUzycia())
				.toString();
		}
		
		return null;
	}
}
